PW.FormValidators.create('add-edit-data-validator', {
    
    callback : function(params){
    	this.windowName = params.windowName;
    	this.mainButtonName = params.mainButtonName;
    	this.forwardButtonName = params.forwardButtonName;
    	this.cancelButtonName = params.cancelButtonName;
    	this.question = params.question;
    	
        this.executeParams = {
            dbName : params.dbName,
            queryId : params.query,
            queryParams : this.getConvertedArray(params.queryParams, params.queryParamsTypes)
        };
        this.showDbWindow();
    },
    
    showDbWindow : function(){
        const me = this;
        this.dbWindow = new Ext4.Window({
                width   : 610,
                title   : me.windowName,
                items: [{
                	margin: '10 10 10 10',
                    xtype: 'component',
                    html: me.question
                },
                {
                    buttons : [{
                                text    : me.mainButtonName,
                                handler : me.executeQuery,
                                scope : me
                            },
                            {
                                text    : me.forwardButtonName,
                                handler : me.confirm,
                                scope : me
                            },
                            {
                                text    : me.cancelButtonName,
                                handler : me.closeWindow,
                                scope : me
                            }
                        ]
                }]
                
        });
        this.dbWindow.show();
        let width = 90;
        this.dbWindow.query('button').forEach(function( button ){
            width += button.getWidth();
        });
        this.dbWindow.setWidth(width);
        this.dbWindow.doLayout();
    },
    
    executeQuery : function(){
        this.closeWindow();
        const me = this;
        jQuery.ajax({
            url: 'plugin/com.suncode-cuf-components/actions/data/execute',
            contentType: "application/json",
            data: JSON.stringify(me.executeParams),
            async: false,
            method: 'POST',
            success: function(response){
            	me.confirm();
            },
            error : function(jqXHR, textStatus, errorThrown){
                MessageService.showFailure('Błąd w trakcie pobierania danych z servleta. Komunikat błędu: ' + errorThrown);
            }
        });
    },
    
    getConvertedArray : function(array, types){
        const resultArr = [];
        PW.each(array, function(param, index){
            let convertedParam = param;
            if(types[index] == "integer" || types[index] == "float"){
                convertedParam = Number(param);
            }
            else if(types[index] == "date" || types[index] == "datetime"){
            	convertedParam = new Date(param);
            }
            resultArr.push(convertedParam);
        }, this);
        return resultArr;
    },
    
    closeWindow : function(){
        this.dbWindow.close();
    }
});
