PWE.integrationComponent.registerApplication("cuf-components.common.documents.libreoffice.applications.ConvertDocumentToPdf", {
    apiVersion: 2,
    buildForm: (form) => buildForm(form),
    validateForm: (form) => validateForm(form)
});

function buildForm(form) {
    form.addCombobox({
        id: "sourceClassName",
        remote: {
            url: "plugin/com.suncode-cuf-components/docs/docClassList",
            fields: [
                {
                    name: "displayName",
                    type: "string"
                },
                {
                    name: "name",
                    type: "string"
                }
            ],
        },
        valueField: "name",
        displayField: "displayName",
        sort: [
            {
                property: "displayName",
                direction: "ASC"
            }
        ]
    });

    form.addField({
        id: "newVersion",
        listeners: {
            change: (value) => value ? form.hide("destinationClassName") : form.show("destinationClassName")
        }
    });

    form.addCombobox({
        id: "destinationClassName",
        remote: {
            url: "plugin/com.suncode-cuf-components/docs/docClassList",
            fields: [
                {
                    name: "displayName",
                    type: "string"
                },
                {
                    name: "name",
                    type: "string"
                }
            ],
        },
        valueField: "name",
        displayField: "displayName",
        sort: [
            {
                property: "displayName",
                direction: "ASC"
            }
        ]
    });
}

function validateForm(form) {
    let isLicenceValid, isLibreOfficeInstalled;

    jQuery.ajax({
        url: PW.getAbsolutePath("plugin/com.suncode-cuf-components/libreoffice/check/installation"),
        type: 'GET',
        async: false,
        success: (responseData) => isLibreOfficeInstalled = (responseData === "true")
    });

    jQuery.ajax({
        url: PW.getAbsolutePath("plugin/com.suncode-cuf-components/libreoffice/check/licence"),
        type: 'GET',
        async: false,
        success: (responseData) => isLicenceValid = (responseData === "true")
    });

    if (!isLibreOfficeInstalled) {
        form.showErrorMessage(CUFCommon.t('error.libreOfficeNotInstalled'));
    }

    if (!isLicenceValid) {
        form.showErrorMessage(CUFCommon.t('error.licenceNotValid'));
    }

    return isLibreOfficeInstalled === true && isLicenceValid === true;
}