/**
 * PWE form of AttachedDocumentsValidator.
 */
PWE.integrationComponent.registerValidator('attached-doc-from-class-validator', {
    apiVersion: 2,
    buildForm: function (form, options) {
        CufComp.addComboboxClassList("docClasses", null, form);
        form.addField({
            id: "attachedHere", listeners: {
                change: function (value) {
                    if (value === true) {
                        form.hide("attachedToActivityType");
                        form.setValue("attachedToActivityType", "ALL");
                        form.setNotEmpty("attachedToActivityType", false);
                        form.resetArray("activities");
                    } else {
                        form.show("attachedToActivityType");
                        form.setNotEmpty("attachedToActivityType", true);
                    }
                }
            }
        });

        form.addCombobox({
            id: "attachedToActivityType",
            optional: form.getValue("attachedHere") !== false,
            hidden: form.getValue("attachedHere") !== false,
            values: [
                {id: "ALL", display: CUFCommon.t("attached-doc-from-class-validator.form.all")},
                {id: "CUSTOM", display: CUFCommon.t("attached-doc-from-class-validator.form.custom")},
                {id: "CURRENT", display: CUFCommon.t("attached-doc-from-class-validator.form.current")}
            ],
            listeners: {
                change: function (value) {
                    if (value === "CUSTOM") {
                        form.show("activities");
                        form.setNotEmpty("activities", true);
                    } else {
                        form.hide("activities");
                        form.setNotEmpty("activities", false);
                        form.resetArray("activities");
                    }
                }
            }
        });

        form.addCombobox({
            id: "activities",
            hidden: form.getValue("attachedHere") === true || form.getValue("attachedToActivityType") !== "CUSTOM",
            notEmpty: form.getValue("attachedHere") === false && form.getValue("attachedToActivityType") === "CUSTOM",
            values: form.getAllTasks().map(({id, name}) => ({id: id, display: name})),
        });

        form.addField("alert");
        form.addField("confirmation");
    }
}); 
