/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.user.datachoosers;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.db.datachoosers.utils.DCConverter;
import com.suncode.cuf.common.user.UserDataService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@DataChooser
public class UserDataChooser {
    private static Logger log = LoggerFactory.getLogger(UserDataChooser.class);
    @Autowired
    private UserDataService uds;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("user-datachooser")).name("dc.user-datachooser.name")).description("dc.user-datachooser.desc")).category(new Category[]{Categories.USER})).documentationLink("confluence/x/8oLK")).icon((Icon)SilkIconPack.USER)).parameter().id("login").name("dc.user-datachooser.login.name").type((Type)Types.STRING).create()).parameter().id("dataType").name("dc.user-datachooser.dataType.name").description("dc.user-datachooser.dataType.desc").type((Type)Types.STRING).create()).parameter().id("filterBy").name("dc.user-datachooser.filterBy.name").description("dc.user-datachooser.filterBy.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("sortBy").name("dc.user-datachooser.sortBy.name").description("dc.user-datachooser.sortBy.desc").type((Type)Types.STRING).defaultValue((Object)"firstname").optional().create()).parameter().id("sortDirection").name("dc.user-datachooser.sortDirection.name").description("dc.user-datachooser.sortDirection.desc").type((Type)Types.STRING).defaultValue((Object)"ASC").optional().create()).mapping().id("firstname").name("dc.user-datachooser.mapping.firstname.name").create().mapping().id("lastname").name("dc.user-datachooser.mapping.lastname.name").create().mapping().id("email").name("dc.user-datachooser.mapping.email.name").create().mapping().id("fullname").name("dc.user-datachooser.mapping.fullname.name").create().mapping().id("number").name("dc.user-datachooser.mapping.number.name").create().mapping().id("groupname").name("dc.user-datachooser.mapping.groupname.name").description("dc.user-datachooser.mapping.groupname.desc").create().mapping().id("positionname").name("dc.user-datachooser.mapping.positionname.name").description("dc.user-datachooser.mapping.positionname.desc").create().mapping().id("positionousymbol").name("dc.user-datachooser.mapping.positionousymbol.name").description("dc.user-datachooser.mapping.positionousymbol.desc").create().mapping().id("positionsymbol").name("dc.user-datachooser.mapping.positionsymbol.name").description("dc.user-datachooser.mapping.positionsymbol.desc").create().mapping().id("superiorUsername").name("dc.user-datachooser.mapping.superiorUsername.name").description("dc.user-datachooser.mapping.superiorUsername.desc").create().mapping().id("superiorFullname").name("dc.user-datachooser.mapping.superiorFullname.name").description("dc.user-datachooser.mapping.superiorFullname.desc").create();
    }

    public void data(ComponentQueryData queryData, DataChooserResult result, ActivityContextMap contextMap, @Param String login, @Param String dataType, @Param String[] filterBy, @Param String sortBy, @Param String sortDirection) {
        try {
            List<Map<String, Object>> userDCData = this.uds.getUserDCData(login, dataType);
            int total = userDCData.size();
            this.filterData(userDCData, queryData.getQuery(), filterBy);
            this.sort(userDCData, sortBy, sortDirection);
            this.pagination(userDCData, queryData.getPagination());
            DCConverter.convertListOfMapsToDCResult(userDCData, result);
            result.setTotal(total);
        }
        catch (Exception e) {
            log.error("Datachooser execution error: ", (Throwable)e);
        }
    }

    private void pagination(List<Map<String, Object>> userDCData, Pagination pagination) {
        ArrayList<Map<String, Object>> tempList = new ArrayList<Map<String, Object>>();
        if (pagination.getLimit() + pagination.getStart() < userDCData.size()) {
            tempList.addAll(userDCData.subList(pagination.getStart(), pagination.getLimit() + pagination.getStart()));
        } else {
            tempList.addAll(userDCData.subList(pagination.getStart(), userDCData.size()));
        }
        userDCData.clear();
        userDCData.addAll(tempList);
    }

    private void sort(List<Map<String, Object>> userDCData, final String sortBy, final String sortDirection) {
        Comparator<Map<String, Object>> mapComparator = new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> m1, Map<String, Object> m2) {
                if (!m1.containsKey(sortBy) || !m2.containsKey(sortBy)) {
                    return 0;
                }
                if (m1.get(sortBy) == null || m2.get(sortBy) == null) {
                    return 0;
                }
                int compareInt = 0;
                String m1Value = String.valueOf(m1.get(sortBy));
                String m2Value = String.valueOf(m2.get(sortBy));
                try {
                    Double parseParam1 = Double.valueOf(m1Value);
                    Double parseParam2 = Double.valueOf(m2Value);
                    compareInt = parseParam1.compareTo(parseParam2);
                }
                catch (Exception e) {
                    compareInt = m1Value.compareTo(m2Value);
                }
                if (sortDirection.equalsIgnoreCase("DESC")) {
                    compareInt *= -1;
                }
                return compareInt;
            }
        };
        Collections.sort(userDCData, mapComparator);
    }

    private void filterData(List<Map<String, Object>> userDCData, String query, String[] filterBy) {
        if (!StringUtils.hasText((String)query)) {
            return;
        }
        if (filterBy == null || filterBy.length < 1) {
            return;
        }
        if (filterBy.length == 1 && !StringUtils.hasText((String)filterBy[0])) {
            return;
        }
        ArrayList<Map<String, Object>> filterData = new ArrayList<Map<String, Object>>();
        block0: for (Map<String, Object> row : userDCData) {
            for (String keyFiltr : filterBy) {
                String value;
                if (!row.containsKey(keyFiltr) || !(value = String.valueOf(row.get(keyFiltr)).toLowerCase()).contains(query.toLowerCase())) continue;
                filterData.add(row);
                continue block0;
            }
        }
        userDCData.clear();
        userDCData.addAll(filterData);
    }
}

