/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.services;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.pdfbox.multipdf.Splitter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.springframework.stereotype.Service;

@Service
public class PDFService {
    public Optional<PDDocument> splitIntoOneDocument(PDDocument pdfDocument, int fromPage, int toPage) {
        Splitter splitter = new Splitter();
        splitter.setStartPage(fromPage);
        splitter.setEndPage(toPage);
        splitter.setSplitAtPage(toPage - fromPage + 1);
        List splitDocuments = splitter.split(pdfDocument);
        return splitDocuments.stream().findFirst();
    }

    public List<PDDocument> splitIntoMultipleDocuments(Integer[] fromPages, Integer[] toPages, PDDocument pdfDocument) {
        LinkedList<PDDocument> newDocuments = new LinkedList<PDDocument>();
        IntStream.range(0, fromPages.length).forEach(index -> {
            Optional<PDDocument> splitDocument = this.splitIntoOneDocument(pdfDocument, fromPages[index], toPages[index]);
            if (!splitDocument.isPresent()) {
                throw new RuntimeException("Cannot split document from page " + fromPages[index] + " to page " + toPages[index]);
            }
            newDocuments.add(splitDocument.get());
        });
        return newDocuments;
    }
}

