/**
 * Dynamic form for existing-user-validator.
 */

PWE.integrationComponent.registerValidator( 'existing-user-validator', {
    
    buildForm: function( form ) {
        form.addField("userName");
        form.addField("onlyActive");
        form.addField("userDoesNotExistStatus");
        form.addField({
            id: "confirmation",
            onChange: function(value) {
                if(value) {
                    form.showField("title"); 
                }
                else {
                    form.hideField("title");
                }
            }
        });
        form.addField({
        	id : "title",
			hidden : true
		});
        if (form.getFieldValue("confirmation")) {
        	form.showField("title");
        }
    }
});