/**
 * PWE form of ShowAndAttachDocumentsFromArchive.
 */
PWE.integrationComponent.registerFormAction( 'show-and-attach-document-from-archive', {
    apiVersion: 2,
    buildForm: function( form , options ) {
        var me = this;
        CufComp.addComboboxClassList("document-class-id", {
            change: function (value) {
                if ((!form.hasVariableValue("document-class-id") && !form.hasFunctionValue("document-class-id")) && form.getValue("search-criteria-on")) {
                    me.indexes.setUrl("plugin/com.suncode-cuf-components/docs/docClassIndexList/" + value);
                }
            }
        }, form);
        form.addField({
            id: "search-criteria-on",
            listeners: {
                change: function (value) {
                    if (value) {
                        form.show("index-table");
                        form.show("force-exact-search");
                    } else {
                        form.hide("index-table");
                        form.hide("force-exact-search");
                    }
                }
            }
        });
        var indexTable = form.addTable({id: "index-table", hidden: !form.getValue("search-criteria-on") });
        this.indexes = CufComp.addComboboxClassIndexList("indexes-id", form.getValue("document-class-id"), null, indexTable);
        indexTable.addField("indexes-value");
        CufComp.setClassNameById(form, "document-class-id");
        CufComp.setClassIndexesById(form, "document-class-id", "indexes-id");

        form.addField({id: "force-exact-search", hidden: !form.getValue("search-criteria-on")});
    }
}); 