/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.datasource.applications;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceParameter;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-pwe/execute-datasource.js")
public class ExecuteDatasource {
    private static final Logger log = LoggerFactory.getLogger(ExecuteDatasource.class);

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("execute-datasource")).name("application.datasources.execute-datasource.name")).description("application.datasources.execute-datasource.desc")).icon((Icon)SilkIconPack.DATABASE)).category(new Category[]{Categories.DATASOURCES})).parameter().id("datasource").name("datasource.param.datasource.name").description("datasource.param.datasource.desc").type((Type)Types.STRING).create()).parameter().id("datasources").name("datasource.param.datasources.name").description("datasource.param.datasources.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("datasourceInputParametersId").name("datasource.datasourceInputParametersId.name").description("datasource.datasourceInputParametersId.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("datasourceInputParametersValue").name("datasource.datasourceInputParametersValue.name").description("datasource.datasourceInputParametersValue.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("datasourceOutputParametersId").name("datasource.datasourceOutputParametersId.name").description("datasource.datasourceOutputParametersId.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("datasourceOutputParametersValue").name("datasource.datasourceOutputParametersValue.name").description("datasource.datasourceOutputParametersValue.desc").type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("manyValuesHandler").name("datasource.param.manyValuesHandler.name").description("datasource.param.manyValuesHandler.desc").type((Type)Types.STRING).defaultValue((Object)"block").create()).parameter().id("overwriteData").name("datasource.param.overwriteData.name").description("datasource.param.overwriteData.desc").type((Type)Types.BOOLEAN).defaultValue((Object)true).create();
    }

    public void execute(@Param DataSourceInstance datasource, Parameters parameters) {
        this.run(datasource, parameters);
    }

    public void set(@Param DataSourceInstance datasource, Parameters parameters) {
        this.run(datasource, parameters);
    }

    private void run(DataSourceInstance datasource, Parameters parameters) {
        Assert.notNull((Object)datasource, (String)"Chosen datasource does not exist!");
        Map<String, String> inputParametersMap = this.getInputParametersMap(parameters, datasource.getInputParameters());
        log.debug("Executing datasource with parameters: " + inputParametersMap);
        CountedResult countedData = datasource.execute(inputParametersMap, null);
        if (countedData.getData().size() <= 0) {
            log.debug("Datasource returned no data - nothig to set...");
            return;
        }
        Map<String, List<Object>> outputParametersMap = this.prepareOutputParametersMap((String[])parameters.get("datasourceOutputParametersId", String[].class), datasource.getOutputParameters());
        this.fillOutputParametersMap(outputParametersMap, countedData.getData());
        this.setVariablesWithParameters((String[])parameters.get("datasourceOutputParametersId", String[].class), (Variable[])parameters.get("datasourceOutputParametersValue", Variable[].class), outputParametersMap, (String)parameters.get("manyValuesHandler", String.class), (Boolean)parameters.get("overwriteData", Boolean.TYPE));
    }

    private Map<String, String> getInputParametersMap(Parameters parameters, Set<DataSourceParameter> datasourceInputParameters) {
        String[] inputParametersId = (String[])parameters.get("datasourceInputParametersId", String[].class);
        String[] inputParametersValue = DataConverter.argumentToStringArray(parameters.getRaw("datasourceInputParametersValue"));
        return IntStream.range(0, inputParametersId.length).boxed().filter(i -> datasourceInputParameters.stream().anyMatch(datasourceInputParameter -> datasourceInputParameter.getId().equals(inputParametersId[i]))).collect(Collectors.toMap(i -> inputParametersId[i], i -> inputParametersValue[i] != null ? inputParametersValue[i] : "", (key, value) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", key));
        }, LinkedHashMap::new));
    }

    private Map<String, List<Object>> prepareOutputParametersMap(String[] datasourceOutputParametersId, Set<DataSourceParameter> datasourceOutputParameters) {
        return IntStream.range(0, datasourceOutputParametersId.length).boxed().filter(i -> datasourceOutputParameters.stream().anyMatch(datasourceOutputParameter -> datasourceOutputParameter.getId().equals(datasourceOutputParametersId[i]))).collect(Collectors.toMap(i -> datasourceOutputParametersId[i], i -> new ArrayList(), (key, value) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", key));
        }, LinkedHashMap::new));
    }

    private void fillOutputParametersMap(Map<String, List<Object>> outputParametersMap, List<Map<String, Object>> data) {
        data.stream().forEach(row -> outputParametersMap.forEach((id, list) -> list.add(row.get(id))));
    }

    private void setVariablesWithParameters(String[] datasourceOutputParametersId, Variable[] datasourceOutputParametersVariable, Map<String, List<Object>> outputParametersMap, String manyValuesHandler, Boolean overwriteData) {
        for (int i = 0; i < datasourceOutputParametersVariable.length; ++i) {
            if (!outputParametersMap.containsKey(datasourceOutputParametersId[i])) continue;
            if (datasourceOutputParametersVariable[i].isArray()) {
                if (overwriteData.booleanValue()) {
                    this.setVariable(outputParametersMap.get(datasourceOutputParametersId[i]), datasourceOutputParametersVariable[i]);
                    continue;
                }
                this.appendDataToVariable(outputParametersMap.get(datasourceOutputParametersId[i]), datasourceOutputParametersVariable[i]);
                continue;
            }
            if (outputParametersMap.get(datasourceOutputParametersId[i]).size() > 1) {
                if (manyValuesHandler.equalsIgnoreCase("first")) {
                    this.handleFirstVariant(outputParametersMap.get(datasourceOutputParametersId[i]), datasourceOutputParametersVariable[i]);
                    continue;
                }
                if (manyValuesHandler.equalsIgnoreCase("unique")) {
                    this.handleUniqueVariant(outputParametersMap.get(datasourceOutputParametersId[i]), datasourceOutputParametersVariable[i]);
                    continue;
                }
                throw new RuntimeException("Datasource is returning more than one set of values. Cannot map it to variable that is not an array type!");
            }
            this.setVariable(outputParametersMap.get(datasourceOutputParametersId[i]), datasourceOutputParametersVariable[i]);
        }
    }

    private void setVariable(List<Object> parameters, Variable variable) {
        String listValues = StringUtils.join(parameters, (String)";");
        variable.setValue(DataConverter.stringToObject(listValues, variable.getType()));
    }

    private void appendDataToVariable(List<Object> parameters, Variable variable) {
        Object[] previousVariableValue = (Object[])variable.getValue();
        String listValues = StringUtils.join((Object[])previousVariableValue, (String)";") + ";" + StringUtils.join(parameters, (String)";");
        variable.setValue(DataConverter.stringToObject(listValues, variable.getType()));
    }

    private void handleFirstVariant(List<Object> parameters, Variable variable) {
        variable.setValue(DataConverter.stringToObject(parameters.get(0).toString(), variable.getType()));
    }

    private void handleUniqueVariant(List<Object> parameters, Variable variable) {
        String listValues = StringUtils.join((Iterable)parameters.stream().distinct().collect(Collectors.toList()), (String)";");
        variable.setValue((Object)listValues);
    }
}

