PW.FormValidators.create('find-duplicates-validator', {

    callback: function (params) {
        this.duplicatesProcessesIds = params.data;
        this.duplicatesTotalCount = params.duplicatesTotalCount;
        this.duplicatePresentationComboBox = params.duplicatePresentationComboBox;
        this.variablesToCheck = params.variablesToCheck;
        this.message = params.message;
        this.saveDataToVariables = params.saveDataToVariables;
        this.setDataButtonName = params.setDataButtonName;
        this.variablesToGetData = params.variablesToGetData;
        this.variablesToSetData = params.variablesToSetData;
        this.addColumnWithProcessName = params.addColumnWithProcessName;
        this.dataVariables = params.dataVariables;
        this.isHiddenColumn = params.isHiddenColumn;
        this.addLinkToProcess = params.addLinkToProcess;
        this.addLinkToDocuments = params.addLinkToDocuments;
        this.allowAcceptanceDespiteDuplicates = params.allowAcceptanceDespiteDuplicates;
        this.customAcceptanceButtonText = params.customAcceptanceButtonText;
        this.customContinueButtonText = params.customContinueButtonText;
        this.processDefId = ActivityInfoService.getProcessDefId();
        this.processId = ActivityInfoService.getProcessId();
        if (this.duplicatePresentationComboBox === "BASIC") {
            this.showDuplicateWindow();
        }
        if (this.duplicatePresentationComboBox === "EXTENDEND") {
            this.showDuplicatesWindow();
        }
        if (this.message) {
            this.markErrors();
        }
    },

    showDuplicateWindow: function () {
        if (MobileService.isMobile()) {
            MessageService.showFailure(CUFCommon.t('action.mobileUnsupported'));
            return;
        }
        if (!this.duplicateWindow) {
            let windowId = 'find-duplicates-validator' + CUFCommon.generateDefaultButtonId();
            this.defineDuplicateWindow(windowId, this);
            this.duplicateWindow = Ext4.create(windowId);
        }
        this.duplicateWindow.show();
    },

    defineDuplicateWindow: function (id, scope) {
        let me = this;
        return new Ext4.define(id, {
            extend: 'Ext4.window.Window',
            width: 600,
            layout: 'fit',
            modal: true,
            buttonAlign: 'right',
            closable: false,
            title: CUFCommon.t('action.find-duplicates-action.duplicates-found-title'),
            items: [
                {
                    margin: '0 10 20 10',
                    xtype: 'component',
                    html: CUFCommon.t('action.find-duplicates-action.duplicates-found-body') + scope.getVariablesToCheckNames()
                }],
            buttons: [
                {
                    text: this.getContinueButtonText(),
                    itemId: 'continueButton',
                    handler: function () {
                        this.duplicateWindow.hide();
                    },
                    scope: scope
                }, {
                    text: this.getContinueAcceptanceButtonText(),
                    itemId: 'continueAcceptanceButton',
                    hidden: !this.allowAcceptanceDespiteDuplicates,
                    handler: function () {
                        me.confirm();
                    },
                    scope: scope
                }, {
                    text: CUFCommon.t('action.find-duplicates-action.details-button'),
                    itemId: 'detailsButton',
                    handler: this.showDuplicatesWindow,
                    scope: scope
                }]
        });
    },

    showDuplicatesWindow: function () {
        let data = this.duplicatesProcessesIds;
        let me = this;
        let cfg = {
            filters: [],
            sorters: [],
            processDefId: ActivityInfoService.getProcessDefId(),
            processIds: data,
            userName: sTaskUserName,
            variablesIds: me.getColumnIndexes()
        };
        me.cufWindow = CUF.DataService.showDataWin({
            query: cfg,
            type: 'webservice',
            winCfg: {
                title: this.duplicatesTotalCount > 100 ?
                    CUFCommon.t('action.find-duplicates-action.duplicates-window-title-with-limit', data.length, this.duplicatesTotalCount) :
                    CUFCommon.t('action.find-duplicates-action.duplicates-window-title'),
                buttons: [
                    {
                        text: this.getContinueButtonText(),
                        itemId: 'continueButton',
                        handler: function () {
                            me.duplicateWindow.hide();
                            me.cufWindow.close();
                        }
                    }, {
                        text: this.getContinueAcceptanceButtonText(),
                        itemId: 'continueAcceptanceButton',
                        hidden: !this.allowAcceptanceDespiteDuplicates,
                        handler: function () {
                            me.confirm();
                        }
                    }
                ]
            },
            columns: me.getColumnParameters(),
            fields: me.getFields(),
            url: 'plugin/com.suncode-cuf-components/processes/data',
            gridCfg: {
                tbar: me.saveDataToVariables ? me.getButtons() : [],
                numbered: true,
                selectionType: 'SINGLE',
                showRowCount: true,
                pageSize: Suncode.getUserPageSize(),
                rememberSelection: true,
                checkboxSelection: me.saveDataToVariables
            }
        });
    },

    getButtons: function () {
        let me = this;
        return [
            {
                text: this.setDataButtonName,
                xtype: 'button',
                handler: function () {
                    let grid = this.up("grid");
                    me.moveSelected(grid);
                    me.cufWindow.hide();
                }
            }
        ];
    },

    moveSelected: function (grid) {
        return PW.map(this.variablesToGetData, function (variable, i) {
            let selected = grid.getSelectionModel().getSelection()[0];
            VariableService.setValue(this.variablesToSetData[i].id, selected.get(variable.id));
        }, this);
    },

    getColumnParameters: function () {
        let params = [];
        params = params.concat(PW.map(this.dataVariables, function (variable, i) {
            return {
                text: variable.name,
                dataIndex: variable.id,
                hidden: this.isHiddenColumn ? this.isHiddenColumn[i] : false,
                flex: 1,
                sortable: false
            };
        }, this));

        if (this.addColumnWithProcessName) {
            params.push({
                text: CUFCommon.t('default.process-name'),
                dataIndex: "process_name",
                flex: 1
            });
        }
        if (this.addLinkToDocuments) {
            params.push({
                text: CUFCommon.t('default.documents-preview'),
                dataIndex: "document_preview",
                flex: 1
            });
        }
        if (this.addLinkToProcess) {
            params.push({
                text: CUFCommon.t('default.link-to-process'),
                dataIndex: "link_to_process",
                flex: 1
            });
        }
        return params;
    },

    getColumnIndexes: function () {
        return PW.map(this.dataVariables, function (variable, i) {
            return variable.id;
        }, this);
    },

    getFields: function () {
        let fields = [];
        fields = fields.concat(this.getColumnIndexes());

        if (this.addColumnWithProcessName) {
            fields.push("process_name");
        }
        if (this.addLinkToDocuments) {
            fields.push("document_preview");
        }
        if (this.addLinkToProcess) {
            fields.push("link_to_process");
        }
        return fields;
    },

    getContinueButtonText: function () {
        if (this.customContinueButtonText) {
            return this.customContinueButtonText;
        } else {
            return CUFCommon.t('action.find-duplicates-action.continue-button');
        }
    },

    getContinueAcceptanceButtonText: function () {
        if (this.customAcceptanceButtonText) {
            return this.customAcceptanceButtonText;
        } else {
            return CUFCommon.t('action.find-duplicates-action.continue-acceptance-button');
        }
    },

    getVariablesToCheckNames: function () {
        return this.variablesToCheck.map(variable => variable.name).join(", ");
    },

    markErrors: function () {
        for (const variable of this.variablesToCheck) {
            VariableService.unmarkError(variable.id);
            VariableService.markError(variable.id, this.message);
        }
    },
});