PWE.integrationComponent.registerFormAction('table-get-records', {
    apiVersion: 2,
    buildForm: (form, options) => buildActionForm(form, options),
    validateForm: (api) => validate(api)
});

PWE.integrationComponent.registerApplication('table-get-records-app', {
    apiVersion: 2,
    buildForm: (form) => build(form),
    validateForm: (api) => validate(api)
});

PWE.integrationComponent.registerVariablesSetter('table-get-records-app', {
    apiVersion: 2,
    buildForm: (form) => build(form),
    validateForm: (api) => validate(api)
});

function buildActionForm(form, options) {
    addTableIdField(form);
    if (options.destination === 'BUTTON') {
        form.setNotEmpty('tableId', true);
    }
    form.addField('tableStore');
}

function build(form) {
    addTableIdField(form);
    form.addCombobox({
        id: 'activityDefId',
        values: form.getAllTasks().map(({id, name}) => ({id: id, display: name})),
        forceSelection: false
    });
    form.addField('tableStore');
}

function addTableIdField(form) {
    let globalTables = form.getAllGlobalTables();
    if (globalTables.length) {
        form.addCombobox({
            id: 'tableId',
            values: globalTables.map(({id, name}) => ({id: id, display: name})),
            forceSelection: false
        });
    } else {
        form.addField('tableId');
    }
}

function validate(api) {
    if (api.getVariableType('tableStore') !== 'string') {
        api.markError('tableStore');
        api.showErrorMessage(CUFCommon.t('form-valid-string'));
        return false;
    }
    return true;
}