PWE.integrationComponent.registerApplication('synchro-indexes-from-variables', {
    apiVersion: 2,
    buildForm: function(form) {
        buildSetIndexesInDocumentsForm(form);
    },
    validateForm: function(api) {
        return validateIndexTables(api);
    }
});

PWE.integrationComponent.registerVariablesSetter('synchro-indexes-from-variables', {
    apiVersion: 2,
    buildForm: function(form) {
        buildSetIndexesInDocumentsForm(form);
    },
    validateForm: function(api) {
        return validateIndexTables(api);
    }
});

function buildSetIndexesInDocumentsForm(form) {
    addDocumentsSourceForUpdatingIndexesCombobox(form);
    form.addField("fileIds");
    form.addField("documentIds");
    addDocumentClassComboboxAndIndexMappingTable(form);
    afterFormLoad(form);
}

function addDocumentsSourceForUpdatingIndexesCombobox(form) {
    form.addCombobox({
        id: "documentsSourceForUpdatingIndexes",
        values: [
            {id: "PROCESS", display: CUFCommon.t("cuf-components.synchro-indexes-from-variables.documents-source-for-updating-indexes.process")},
            {id: "FILEIDS", display: CUFCommon.t("cuf-components.synchro-indexes-from-variables.documents-source-for-updating-indexes.file-ids")},
            {id: "DOCUMENTIDS", display: CUFCommon.t("cuf-components.synchro-indexes-from-variables.documents-source-for-updating-indexes.document-ids")}
        ],
        listeners: {
            change: function (value) {
                if (value === "PROCESS") {
                    toggleFieldsWhenDocumentsSourceForUpdatingIndexesEqualsProcess(form);
                } else if (value === "FILEIDS") {
                    toggleFieldsWhenDocumentsSourceForUpdatingIndexesEqualsFileIds(form);
                } else if (value === "DOCUMENTIDS") {
                    toggleFieldsWhenDocumentsSourceForUpdatingIndexesEqualsDocumentIds(form);
                } else if (form.hasFunctionValue("documentsSourceForUpdatingIndexes") ||
                    form.hasVariableValue("documentsSourceForUpdatingIndexes")) {
                    toggleFieldsWhenDocumentsSourceForUpdatingIndexesIsFunctionOrVariable(form);
                } else {
                    toggleFieldsWhenDocumentsSourceForUpdatingIndexesIsEmpty(form);
                }
            }
        }
    });
}

function addDocumentClassComboboxAndIndexMappingTable(form) {
    let me = this;
    CufComp.addComboboxClassList("docClass", {
        change: function (value) {
            if (value === null || value === '') {
                toggleFieldsWhenDocumentClassIsEmpty(form);
            }
            else if (form.hasVariableValue("docClass") || form.hasFunctionValue("docClass")) {
                indexesWithVariablesTable.clear();
                toggleFieldsWhenDocumentClassIsFunctionOrVariable(form);
            }
            else
            {
                indexesWithVariablesTable.clear();
                let docClassUrl = "plugin/com.suncode-cuf-components/docs/docClassIndexList/" + value;
                me.indexesWithVariablesCombobox.setUrl(docClassUrl);
                me.indexesWithValuesCombobox.setUrl(docClassUrl);
                toggleFieldsWhenDocumentClassIsValueFromCombobox(form);
            }
        }
    }, form);

    form.addButton({
        id: "fillIndexesWithVariablesAutomatically",
        text: CUFCommon.t("synchronize-indexes.fill-indexes"),
        handler: function () {
            indexesWithVariablesTable.clear();
            fillIndexes(form, indexesWithVariablesTable);
        }
    });

    let indexesWithVariablesTable = form.addTable({
        id: "index-table",
        name: CUFCommon.t("synchro-indexes-from-variables.index-table")
    });
    this.indexesWithVariablesCombobox = CufComp.addOptionalComboboxClassIndexList("indexes", form.getValue("docClass"), null, indexesWithVariablesTable, false);
    indexesWithVariablesTable.addField({
        id: "variables",
        optional: false
    });

    let indexesWithValuesTable = form.addTable({
        id: "index-from-values-table",
        name: CUFCommon.t("synchro-indexes-from-variables.index-from-values-table")
    });
    this.indexesWithValuesCombobox = CufComp.addOptionalComboboxClassIndexList("indexesToSetFromValues", form.getValue("docClass"), null, indexesWithValuesTable, false);
    indexesWithValuesTable.addField({
        id: "values",
        optional: false
    });
}

function fillIndexes(form, table) {
    jQuery.ajax({
        type: "GET",
        data: {
            query: "",
            start: 0,
            limit: 1000
        },
        url: PlusWorkflow.getAbsolutePath("plugin/com.suncode-cuf-components/docs/docClassIndexList/" + form.getValue("docClass")),
        error: function (jqXHR, textStatus, errorThrown) {
            Logger.error(errorThrown);
        },
        contentType: "application/json; charset=utf-8",
        dataType: "json"
    }).done(function (data) {
        for (let i = 0; i < data.data.length; i++) {
            let indexName = data.data[i]["name"];
            if (!isVariableNameNotDuplicated(form, indexName)) {
                continue;
            }
            table.addRow([
                {id: "indexes", value: data.data[i]["name"]},
                {id: "variables", value: form.getAllVariables().filter(variable => variable.name === indexName).first().id}
            ]);
        }
    });
}

function isVariableNameNotDuplicated(form, indexName) {
    return form.getAllVariables().filter(variable => variable.name === indexName).length === 1;
}

function afterFormLoad(form) {
    if (form.getValue("documentsSourceForUpdatingIndexes") === "PROCESS") {
        toggleFieldsWhenDocumentsSourceForUpdatingIndexesEqualsProcess(form);
    } else if (form.getValue("documentsSourceForUpdatingIndexes") === "FILEIDS") {
        toggleFieldsWhenDocumentsSourceForUpdatingIndexesEqualsFileIds(form);
    } else if (form.getValue("documentsSourceForUpdatingIndexes") === "DOCUMENTIDS") {
        toggleFieldsWhenDocumentsSourceForUpdatingIndexesEqualsDocumentIds(form);
    } else if (form.hasFunctionValue("documentsSourceForUpdatingIndexes") ||
        form.hasVariableValue("documentsSourceForUpdatingIndexes")) {
        toggleFieldsWhenDocumentsSourceForUpdatingIndexesIsFunctionOrVariable(form);
    } else {
        toggleFieldsWhenDocumentsSourceForUpdatingIndexesIsEmpty(form);
    }
}

function toggleFieldsWhenDocumentsSourceForUpdatingIndexesEqualsProcess(form) {
    form.setNotEmpty("docClass", true);
    form.show("docClass");
    toggleDocumentClassDependentFields(form);
    form.setNotEmpty("fileIds", false);
    form.hide("fileIds");
    form.setNotEmpty("documentIds", false);
    form.hide("documentIds");
}

function toggleFieldsWhenDocumentsSourceForUpdatingIndexesEqualsFileIds(form) {
    form.setNotEmpty("fileIds", true);
    form.show("fileIds");
    form.setNotEmpty("docClass", true);
    form.show("docClass");
    toggleDocumentClassDependentFields(form);
    form.setNotEmpty("documentIds", false);
    form.hide("documentIds");
}

function toggleFieldsWhenDocumentsSourceForUpdatingIndexesEqualsDocumentIds(form) {
    form.setNotEmpty("documentIds", true);
    form.show("documentIds");
    form.setNotEmpty("docClass", true);
    form.show("docClass");
    toggleDocumentClassDependentFields(form);
    form.setNotEmpty("fileIds", false);
    form.hide("fileIds");
}

function toggleFieldsWhenDocumentsSourceForUpdatingIndexesIsFunctionOrVariable(form) {
    form.setNotEmpty("fileIds", false);
    form.show("fileIds");
    form.setNotEmpty("documentIds", false);
    form.show("documentIds");
    form.setNotEmpty("docClass", true);
    form.show("docClass");
    toggleDocumentClassDependentFields(form);
}

function toggleFieldsWhenDocumentsSourceForUpdatingIndexesIsEmpty(form) {
    form.setNotEmpty("fileIds", false);
    form.hide("fileIds");
    form.setNotEmpty("documentIds", false);
    form.hide("documentIds");
    form.setNotEmpty("docClass", false);
    form.hide("docClass");
    form.hide("index-table");
    form.hide("index-from-values-table");
}

function toggleDocumentClassDependentFields(form) {
    if (form.getValue("docClass") === null || form.getValue("docClass") === '') {
        toggleFieldsWhenDocumentClassIsEmpty(form);
    }
    else if (form.hasFunctionValue("docClass") || form.hasVariableValue("docClass")) {
        toggleFieldsWhenDocumentClassIsFunctionOrVariable(form);
    } else {
        toggleFieldsWhenDocumentClassIsValueFromCombobox(form);
    }
}

function toggleFieldsWhenDocumentClassIsFunctionOrVariable(form) {
    form.hideButton("fillIndexesWithVariablesAutomatically");
    form.show("index-table");
    form.show("index-from-values-table");
}

function toggleFieldsWhenDocumentClassIsValueFromCombobox(form) {
    form.showButton("fillIndexesWithVariablesAutomatically");
    form.show("index-table");
    form.show("index-from-values-table");
}

function toggleFieldsWhenDocumentClassIsEmpty(form) {
    form.hideButton("fillIndexesWithVariablesAutomatically");
    form.hide("index-table");
    form.hide("index-from-values-table");
}

function validateIndexTables(api) {
    if (api.getValue("indexes").length === 0 && api.getValue("indexesToSetFromValues").length === 0) {
        api.markError("indexes");
        api.markError("variables");
        api.markError("indexesToSetFromValues");
        api.markError("values");
        api.showErrorMessage(CUFCommon.t("cuf-components.synchro-indexes-from-variables.index-table.empty-columns-error"));
        return false;
    }
}