PWE.integrationComponent.registerFormAction('import-from-excel', {
    apiVersion: 2,
    buildForm: function (form, options) {
        var table = form.addTable({
            tableId: "excelFilterTable"
        });
        table.addField("columns");
        table.addCombobox({
            id: "filterTypes",
            values: [
                { id: "==", display: "==" },
                { id: "!=", display: "!=" },
                { id: "<", display: "<" },
                { id: ">", display: ">" },
                { id: "<=", display: "<=" },
                { id: ">=", display: ">=" },
                { id: "regexp", display: "regexp" }
            ]
        });
        table.addField("filterValues");
        form.addField("columnsToImport");
        form.addField("overrideCheckBox");
        form.addField("includeHiddenColumns");

        form.addCombobox({
            id: "automappings",
            values: [
                { id: "DISABLE_ALL", display: CUFCommon.t("import-from-excel.disableAll") },
                { id: "ENABLE_CUSTOM", display: CUFCommon.t("import-from-excel.enableCustom") },
                { id: "ENABLE_ALL", display: CUFCommon.t("import-from-excel.enableAll") }
            ],
            listeners: {
                change: function (value) {
                    if (value == 'ENABLE_CUSTOM') {
                        form.show("variablesWithAutomapping");
                        form.setNotEmpty("variablesWithAutomapping", true);
                    }
                    else {
                        form.resetArray("variablesWithAutomapping");
                        form.hide("variablesWithAutomapping");
                        form.setNotEmpty("variablesWithAutomapping", false);
                    }
                }
            },
            notEmpty: true
        });
        form.addField("variablesWithAutomapping");
        if (form.getValue("automappings") != "ENABLE_CUSTOM") {
            form.hide("variablesWithAutomapping");
        }

        form.addField({
            id: "acceptForm",
            listeners: {
                change: function (value) {
                    acceptFormChange(value, form)
                }
            }
        })
        form.addField("saveData");
        form.addField({ id: "actionName", hidden: true });
        acceptFormChange(form.getValue("acceptForm"), form);

        function acceptFormChange(value, form) {
            if (value) {
                form.show("actionName");
                form.setNotEmpty("actionName", true);
                form.hide("saveData");
                form.setNotEmpty("saveData", false);
                form.setValue("saveData",false);
            } else {
                form.setNotEmpty("actionName", false);
                form.hide("actionName");
                form.resetValue("actionName");
                form.show("saveData");
                form.setNotEmpty("saveData", true);
            }
        }
    }
});