/**
 * Form of generate-document action
 */

PWE.integrationComponent.registerFormAction( 'generate-document', {
    apiVersion : 2,
    buildForm: function( form , options ) {
        form.addCombobox({
            id : "fileDestination",
            value : "archive",
            values : [
                { id: "archive", display: CUFCommon.t("generate-document.file-destination.archive") },
                { id: "preview", display: CUFCommon.t("generate-document.file-destination.preview") }
            ],
            listeners: {
                change: function(value) {
                    if (value === 'preview') {
                        form.hide('show');
                        form.hide('newVersion');
                        form.hide('format');
                        form.setValue("format", "PDF");
                        form.hide('documentName');
                        form.hide('message');
                        form.hide("documentClass");
                        form.hide("attachToProcess");
                        form.hide("successful-generation-message-settings-fs");
                    } else {
                        form.show('show');
                        form.show('newVersion');
                        form.show('format');
                        form.show('documentName');
                        form.show('message');
                        form.show('documentClass');
                        form.show("attachToProcess");
                        form.show("successful-generation-message-settings-fs");
                    }
                }
            }
        });
        form.addField({
            id: "attachToProcess",
            notEmpty: true
        });
        form.addCombobox({
            id : "format",
            values : [
            	{ id: "PDF", display: "PDF" },
            	{ id: "DOCX", display: "DOCX" }
            ]
        });
        form.addField("show");
        form.addField("message");
        CufComp.addComboboxClassList("documentClass", null, form);
        form.addCombobox({
            id : "templateSource",
            values : [
                { id: "PROCESS_TEMPLATE", display: CUFCommon.t("generate-document.template-source.process-template") },
                { id: "PROCESS_ATTACHED_DOCUMENT_TEMPLATE", display: CUFCommon.t("generate-document.template-source.process-attached-document-template") }
            ],
			listeners: {
				change: function(value) {
					if (value === "PROCESS_ATTACHED_DOCUMENT_TEMPLATE"){
			        	form.hide("template");
			        	form.resetValue("template");
			        	form.setNotEmpty("template", false);
			        	form.show("documentTemplateClassName");
			        	form.setNotEmpty("documentTemplateClassName", true);
			        }
			        else{
			        	form.show("template");
			        	form.setNotEmpty("template", true);
			        	form.hide("documentTemplateClassName");
			        	form.resetValue("documentTemplateClassName");
			        	form.setNotEmpty("documentTemplateClassName", false);
			        }
				}
			}
        });
        CufComp.addComboboxClassList("documentTemplateClassName", null, form);
        form.addField({
            id: "template",
            notEmpty: true
        });
        
        form.addField({
            id: "newVersion",
            notEmpty: true
        });
        form.addField("documentName");

        let successfulGenerationMessageSettings = form.addFieldSet({
            id: "successful-generation-message-settings-fs",
            collapsible: true,
            collapsed: false,
            title: CUFCommon.t("generate-document.successful-file-generation-message-settings.name")
        });

        successfulGenerationMessageSettings.addField({
            id: "successfulFileGenerationMessage",
            listeners: {
                change: function(value) {
                    if (value) {
                        toggleFieldsWhenSuccessfulFileGenerationMessageIsTrueOrVariableOrFunction(successfulGenerationMessageSettings);
                    } else {
                        toggleFieldsWhenSuccessfulFileGenerationMessageIsFalse(successfulGenerationMessageSettings);
                    }
                }
            }
        });
        successfulGenerationMessageSettings.addField("messageContent");

        var mappingTable = form.addTable({
            tableId: "mappingTable"
        });
        mappingTable.addField("mappingsIds");
        mappingTable.addField("mappingsValues");
        if (form.getValue("fileDestination") === "preview"){
        	form.hide('show');
            form.hide('newVersion');
            form.hide('format');
            form.hide('documentName');
            form.hide('message');
            form.hide('documentClass');
            form.hide("attachToProcess");
            form.hide("successful-generation-message-settings-fs");
        }
        if (form.getValue("templateSource") === "PROCESS_ATTACHED_DOCUMENT_TEMPLATE"){
        	form.hide("template");
        	form.resetValue("template");
        	form.setNotEmpty("template", false);
        	form.show("documentTemplateClassName");
        	form.setNotEmpty("documentTemplateClassName", true);
        }
        else {
        	form.show("template");
        	form.setNotEmpty("template", true);
        	form.hide("documentTemplateClassName");
        	form.resetValue("documentTemplateClassName");
        	form.setNotEmpty("documentTemplateClassName", false);
        }
        if (successfulGenerationMessageSettings.getValue("successfulFileGenerationMessage")){
            toggleFieldsWhenSuccessfulFileGenerationMessageIsTrueOrVariableOrFunction(successfulGenerationMessageSettings);
        } else {
            toggleFieldsWhenSuccessfulFileGenerationMessageIsFalse(successfulGenerationMessageSettings);
        }
    }
});

function toggleFieldsWhenSuccessfulFileGenerationMessageIsTrueOrVariableOrFunction(form) {
    form.setNotEmpty("messageContent", true);
    form.show("messageContent");
}

function toggleFieldsWhenSuccessfulFileGenerationMessageIsFalse(form) {
    form.setNotEmpty("messageContent", false);
    form.hide("messageContent");
}

PWE.integrationComponent.registerApplication('generate-document-app', {
    apiVersion : 2,
    buildForm: function( form , options ) {
        form.addCombobox({
            id : "format",
            values : [
                { id: "PDF", display: "PDF" },
                { id: "DOCX", display: "DOCX" }
            ]
        });
        CufComp.addComboboxClassList("documentClass", null, form);
        form.addCombobox({
            id : "templateSource",
            values : [
                { id: "PROCESS_TEMPLATE", display: CUFCommon.t("generate-document.template-source.process-template") },
                { id: "PROCESS_ATTACHED_DOCUMENT_TEMPLATE", display: CUFCommon.t("generate-document.template-source.process-attached-document-template") }
            ],
			listeners: {
				change: function(value) {
					if (value == "PROCESS_ATTACHED_DOCUMENT_TEMPLATE"){
			        	form.hide("template");
			        	form.resetValue("template");
			        	form.setNotEmpty("template", false);
			        	form.show("documentTemplateClassName");
			        	form.setNotEmpty("documentTemplateClassName", true);
			        }
			        else{
			        	form.show("template");
			        	form.setNotEmpty("template", true);
			        	form.hide("documentTemplateClassName");
			        	form.resetValue("documentTemplateClassName");
			        	form.setNotEmpty("documentTemplateClassName", false);
			        }
				}
			}
        });
        CufComp.addComboboxClassList("documentTemplateClassName", null, form);
        form.addField({
            id: "template"
            });
        form.addField({
            id: "attachToProcess",
            notEmpty: true
        });
        form.addField({
            id: "newVersion",
            notEmpty: true
        });
        form.addField("documentName");
        var mappingTable = form.addTable({
            tableId: "mappingTable"
        });

        mappingTable.addField("mappingsIds");
        mappingTable.addField("mappingsValues");
        
        if (form.getValue("templateSource") == "PROCESS_ATTACHED_DOCUMENT_TEMPLATE"){
        	form.hide("template");
        	form.resetValue("template");
        	form.setNotEmpty("template", false);
        	form.show("documentTemplateClassName");
        	form.setNotEmpty("documentTemplateClassName", true);
        }
        else{
        	form.show("template");
        	form.setNotEmpty("template", true);
        	form.hide("documentTemplateClassName");
        	form.resetValue("documentTemplateClassName");
        	form.setNotEmpty("documentTemplateClassName", false);
        }
    }
});

