/**
 * PWE form of ValidateUsingFunction.
 */
PWE.integrationComponent.registerValidator('function-based-validator', {
    apiVersion: 2,
    buildForm: function (form, options) {
        form.addField("function");
        form.addCombobox({
            id: "tableOn",
            values: [
                {
                    id: "noTable",
                    display: CUFCommon.t("function-based-validator.notTable")
                },
                {
                    id: "tableWithEveryRow",
                    display: CUFCommon.t("function-based-validator.tableWithEveryRow"),
                    description: CUFCommon.t("function-based-validator.tableWithEveryRow.desc")
                },
                {
                    id: "tableWithAnyRow",
                    display: CUFCommon.t("function-based-validator.tableWithAnyRow"),
                    description: CUFCommon.t("function-based-validator.tableWithAnyRow.desc")
                }
            ],

            listeners: {
                change: function (value) {
                    if (value == "noTable") {
                        form.setValue("everyRowAvailable", false);
                        form.setValue("anyRowAvailable", false);
                        form.hide("tableLength");
                        form.setValue("tableLength", null);
                        form.setNotEmpty("tableLength", false);
                    } else if (value == "tableWithEveryRow") {
                        form.setValue("everyRowAvailable", true);
                        form.setValue("anyRowAvailable", false);
                        form.show("tableLength");
                        form.setNotEmpty("tableLength", true);
                    } else if (value == "tableWithAnyRow") {
                        form.setValue("everyRowAvailable", false);
                        form.setValue("anyRowAvailable", true);
                        form.show("tableLength");
                        form.setNotEmpty("tableLength", true);
                    }
                }
            }
        });
        form.addField({
            id: "tableLength",
            hidden: !(form.getValue("tableOn") == "tableWithEveryRow" || form.getValue("tableOn") == "tableWithAnyRow")
        });
        form.addCombobox({
            id: "messageType",
            values: [
                {id: "global", display: CUFCommon.t("function-based-validator.global")},
                {id: "local", display: CUFCommon.t("function-based-validator.local")},
                {id: "localandglobal", display: CUFCommon.t("function-based-validator.localandglobal")}
            ],
            listeners: {
                change: function (value) {
                    if (value == "global") {
                        table.clear();
                        form.hide("customTable");
                        form.show("confirmation");
                        form.show("alert");

                    } else if (value == "local") {
                        form.show("customTable");
                        form.hide("confirmation");
                        form.hide("alert");
                        form.setValue("alert", "");
                        form.setValue("confirmation", false);
                    } else if (value == "localandglobal") {
                        form.show("customTable");
                        form.hide("confirmation");
                        form.show("alert");
                        form.setValue("confirmation", false);
                    }
                }
            }
        });
        form.addField({
            id: "confirmation",
            hidden: true
        });
        form.addField({
            id: "alert",
            hidden: true
        });
        table = form.addTable({
            id: "customTable",
            hidden: true

        });
        table.addField("variable")
        table.addField("variableMessage")

        form.addField({
            id: "everyRowAvailable",
            hidden: true
        });
        form.addField({
            id: "anyRowAvailable",
            hidden: true
        });
        var msgType = form.getValue("messageType");
        if (msgType == "local") {
            form.show("customTable");
            form.hide("confirmation");
            form.hide("alert");
            if (form.getValue("alert") != "") {
                form.setValue("alert", "");
            }

        } else if (msgType == "localandglobal") {
            form.show("customTable");
            form.hide("confirmation");
            form.show("alert");
            if (form.getValue("confrmation")) {
                form.setValue("confirmation", false);
            }
        } else {
            table.clear();
            form.hide("customTable");
            form.show("confirmation");
            form.show("alert");
            if (form.getValue("messageType") != "global") {
                form.setValue("messageType", "global");
            }
        }
        if (form.getValue("tableOn") != "noTable") {
            form.setNotEmpty("tableLength", true);
        }
    },
    validateForm: function (api) {
        var msgType = api.getValue("messageType");
        var alert = api.getValue("alert");
        return validateEmptyAlert (msgType,alert);
    }
});

function validateEmptyAlert (msgType,alert) {
    var confirmWindow = {
        confirm: true,
        title: CUFCommon.t("dpwe-valid-confirm-title-save"),
        message: CUFCommon.t("dpwe-valid-confirm-msg-empty-alert")
    };
    if (msgType != "local" && alert == "") {
        return confirmWindow;
    }
    return true;
}
