/**
 * Action sets values in given columns.
 */
PW.FormActions.create('set-columns', {
    
	dtButtonInit: function (button) {
    	this.table = button.getVariableSet();
    },
    
    variableSetInit : function (table){
        this.table = table;
        if(this.get("executeTypes").indexOf("TABLE_BUTTON") > -1){
        	this.createTableButton();
        }
    },
    
    defaultActions: {
        variableSet: function(variableSet, added, updated, removed){
        	if(this.get("executeTypes").indexOf("ADDING_ROWS_OPTIMIZED") > -1 && added.length > 0){
        		variableSet.suspendEvent(false);
        		var oldValues = this.getVariablesValues();
                this.setRows(added, false);
                var newValues = this.getVariablesValues();
                variableSet.resumeEvents();
                this.executeChangeEventOnVariables(oldValues);
                
            }
            if(this.get("executeTypes").indexOf("ADDING_ROWS") > -1 && added.length > 0){
                this.setRows(added, true);
            }
            if(this.get("executeTypes").indexOf("UPDATING_COLUMNS") > -1){
                var rows = [];
                for (var j = 0; j < updated.length; j++){
                    if(this.checkUpdate(updated[j])){
                    	rows.push(updated[j]);
                    }
                }
                if (rows.length > 0){
                    this.setRows(rows, true);
                }
            }
            if(this.get("executeTypes").indexOf("DELETING_ROWS") > -1 && removed.length > 0){
            	this.setRows([], true);
            }
        },
        button: function(button){
            this.setRows([], true);
        },
        dtButton: function(button){
        	this.setRows([], true);
        }
    },
    
    enable : function(){
    	var me = this;
        if (this.target.type != "BUTTON" && this.target.type != "DT_BUTTON") {
            if (me.get("executeTypes").indexOf("UPDATING_VARIABLES") > -1) {
                PW.each(me.get("updatingVariables"), function (variable) {
                    variable.on("change", me.setColumn, me);
                });
            }
            if (me.get("executeTypes").indexOf("CONDITIONAL_EXECUTE") > -1) {
                me.setRows([], true);
            }
        }
     	if (me.get("executeTypes").indexOf("TABLE_BUTTON") > -1){
 	    	VariableSetService.enableBottomToolbarButton(me.table.grid, me.buttonId);
    	}
    },
    
    disable : function(){
        var me = this;
        if (this.target.type != "BUTTON" && this.target.type != "DT_BUTTON") {
            if (me.get("executeTypes").indexOf("UPDATING_VARIABLES") > -1) {
                PW.each(me.get("updatingVariables"), function (variable) {
                    variable.off("change", me.setColumn, me);
                });
            }
        }
     	if (me.get("executeTypes").indexOf("TABLE_BUTTON") > -1){
     		VariableSetService.disableBottomToolbarButton(this.table.grid, me.buttonId);
    	}
    },
    
    createTableButton : function() {
        var me = this;
        me.buttonId = me.get("buttonId");
        VariableSetService.addBottomToolbarButton(me.table.grid, {
            text: me.get("buttonName"),
            itemId: me.buttonId,
            iconCls: 'silk-arrow-right',
            disabled: true,
            handler: function() {
                me.get("useSelectedRow") ? me.setSelectedRow() : me.setRows();
            }
        });
    },
    
    checkUpdate : function(updated) {
    	var updateCol = this.get("updatingColumns");
        for (var i = 0; i < updateCol.length; i++){
            if(updated.changes.indexOf(updateCol[i].getId()) > -1 ){
                return true;
            }
        }
        return false;
    },

    setRows : function(rows, queueEvents) {
        this.suspendEvents(queueEvents);
        if (devMode){
    		Logger.debug("Action set-columns will now set variables...");
    	}

        if (!PW.isEmpty(rows)){
            PW.each(rows, function(row){
                this.setRow(row.index);
            }, this);
        } else{
            var len = this.get("columns")[0].getValue().length;
            for (var i = 0; i < len; i++){
                this.setRow(i);
            }
        }
        this.resumeEvents();
    },
    
    setRow : function(index){
    	var columns = this.get("columns");
    	var values = this.get("functions");
    	
    	this.setContextVariable("currentRow", index);
    	if(!this.get("condition") || this.get("condition").call()){
        	for (var i = 0; i < columns.length; i++){
        		columns[i].setItemValue(values[i].call(), index);
        	}
        }
    },
    
    setSelectedRow: function(){
        var selected = VariableSetService.getSelected(this.table.grid);
        var index = VariableSetService.getRowIndex(this.table.grid, selected);
        this.suspendEvents(true);
        this.setRow(index);
        this.resumeEvents();
    },
    
    setColumn : function(updatedCell, columnValue, columnValues){
        this.setRows([], true);
    },
    
    suspendEvents : function(queue){
        var columns = this.get("columns");
        for (var i = 0; i < columns.length; i++){
            columns[i].suspendEvents(queue);
        }  
    },
    
    resumeEvents : function(){
        var columns = this.get("columns");
        for (var i = 0; i < columns.length; i++){
            columns[i].resumeEvents();
        }
    },
    
    getVariablesValues : function(){
    	var me = this;
    	var values = [];
    	PW.each(me.get("columns"), function (variable){
    	    values.push(variable.getValue());
    	});
    	return values;
    },
    
    executeChangeEventOnVariables : function(oldValues){
    	var me = this;
    	var newValues = this.getVariablesValues();
    	PW.each(me.get("columns"), function (variable, index){
    		variable.fireEvent('livechange', variable, newValues[index], oldValues[index]);
    		variable.fireEvent('change', variable, newValues[index], oldValues[index]);
    	});
    }
});