var messageService = ServiceFactory.getMessageService();
/**
 * Return exchange rate action implementation.
 */
PW.FormActions.create('exchange-rate-action', {
    variableInit: function (variable) {
        this.variableToSet = variable;
    },
    enable: function () {
        let me = this;
        if (this.get("executeTypes").indexOf("UPDATING_VARIABLES") > -1) {
            PW.each(me.get("updatingVariables"), function (variable) {
                variable.on("change", me.setExchangeRate, me);
            });
        }
        if (this.get("executeTypes").indexOf("CONDITIONAL_EXECUTE") > -1) {
            me.setExchangeRate();
        }
        if (me.get("executeTypes").indexOf("CURRENCY_OR_DATE_UPDATE") > -1) {
            this.getRaw('currency').on('change', me.setExchangeRate, me);
            this.getRaw('date').on('change', me.setExchangeRate, me);
            this.getRaw('dateOffset').on('change', me.setExchangeRate, me);
        }
    },
    disable: function () {
        let me = this;
        if (me.get("executeTypes").indexOf("UPDATING_VARIABLES") > -1) {
            PW.each(me.get("updatingVariables"), function (variable) {
                variable.off("change", me.setExchangeRate, me);
            });
        }
        if (me.get("executeTypes").indexOf("CURRENCY_OR_DATE_UPDATE") > -1) {
            this.getRaw('currency').off('change', me.setExchangeRate, me);
            this.getRaw('date').off('change', me.setExchangeRate, me);
            this.getRaw('dateOffset').off('change', me.setExchangeRate, me);
        }
    },
    setExchangeRate: function () {
        const variableToSet = this.variableToSet;
        const params = this.getParams();
        const tableNoVar = this.get('tableNo');
        const tableNameVar = this.get('tableName');
        const effectiveDateVar = this.get("effectiveDate");

        if (params) {
            variableToSet.lock();
            jQuery.ajax({
                url: 'plugin/com.suncode-cuf-components/exchangerate/notimezone/pln',
                type: "GET",
                data: params,
                success: function (data) {
                    if (devMode) {
                        Logger.debug("Action pln-exchange-rate will now set variable...");
                    }

                    variableToSet.setValue(data.mid);

                    if (tableNoVar) {
                        tableNoVar.setValue(data.no)
                    }

                    if (tableNameVar) {
                        tableNameVar.setValue(data.table)
                    }

                    if (effectiveDateVar) {
                        effectiveDateVar.setValue(data.effectiveDate);
                    }

                    variableToSet.unlock();
                },
                async: false,
                error: function () {
                    variableToSet.unlock();
                    MessageService.showFailure(CUFCommon.t("error.nbp.msg"));
                }
            });
        }
    },
    getParams: function () {
        const date = this.get("date");
        const currency = this.get("currency");
        const dateOffset = this.get("dateOffset");

        if (PW.isEmpty(currency) || PW.isEmpty(date)) {
            return;
        }

        const formattedDate = Ext4.Date.format(Ext4.Date.add(date, Ext4.Date.DAY, dateOffset), "Y-m-d");
        return {
            currency: currency,
            date: formattedDate,
            activityId: ActivityInfoService.getActivityId()
        };
    }
});

