PW.FormActions.create('add-comment-action', {
    init: function () {
        this.commentAdded = false;
    },

    defaultActions: {
        button: function (button) {
            let allowEmptyComment = this.get("allowEmptyComment");
            if (button.isAcceptanceButton()) {
                if (!this.commentAdded) {
                    this.showCommentWindow(allowEmptyComment, button.getId());
                    return false;
                }
            } else {
                this.showCommentWindow(allowEmptyComment);
            }
            return true;
        }
    },

    disable: function () {
        if (FormService.isAcceptanceBlocked()) {
            FormService.unblockAcceptance();
        }
    },

    showCommentWindow: function (allowEmptyComment, acceptButtonId) {
        FormService.blockAcceptance();
        createCommentWindow(allowEmptyComment, acceptButtonId);
        let me = this;

        function createCommentWindow(allowEmptyComment, acceptButtonId) {
            let windowId = 'add-comment-action-window' + CUFCommon.generateDefaultButtonId();
            let acceptButtonCfg = {
                success: function () {
                    closeWindow();
                    me.commentAdded = true;
                    if (acceptButtonId) {
                        FormService.accept({
                            actionName: acceptButtonId
                        });
                    }
                },
                failure: function (response) {
                    Ext4.Msg.show({
                        title: CUFCommon.t("leave-comment.errortitle"),
                        msg: CUFCommon.t("leave-comment.errormsg") + response,
                        buttons: Ext4.Msg.OK,
                        icon: Ext4.Msg.ERROR
                    });
                },
                scope: this
            };
            CUFCommon.defineCommentWindow(windowId, acceptButtonCfg, closeWindow, this, allowEmptyComment);
            this.commentWindow = Ext4.create(windowId);
            this.commentWindow.show();
        }

        function closeWindow() {
            this.commentWindow.hide();
            FormService.unblockAcceptance();
        }
    }
});