PW.Functions.register("toJsonObject", "string", ["string[]", "string[]", "string[]"], function(keys, values, types){
	var jsonObject = {};
	for (var i=0; i<keys.length; i++){
		switch(types[i]){
		 case "STRING":
		 	createStringField(jsonObject, keys[i], values[i]);
		 	break;
		 case "INTEGER":
		 	createIntegerField(jsonObject, keys[i], values[i]);
		 	break;
		 case "FLOAT":
		 	createDoubleField(jsonObject, keys[i], values[i]);
		 	break;
		 case "BOOLEAN":
		 	createBooleanField(jsonObject, keys[i], values[i]);
		 	break;
		 case "OBJECT":
		 	createObjectField(jsonObject, keys[i], values[i]);
		 	break;
		 case "ARRAY":
		 	createArrayField(jsonObject, keys[i], values[i]);
		}
	}
	return JSON.stringify(jsonObject);
});

PW.Functions.register("toJsonArray", "string", ["string[]", "string"], function(values, type){
	var jsonArray = [];
	for (var i=0; i<values.length; i++){
		switch(type){
		 case "STRING":
		 	createStringValue(jsonArray, values[i]);
		 	break;
		 case "INTEGER":
		 	createIntegerValue(jsonArray, values[i]);
		 	break;
		 case "FLOAT":
		 	createDoubleValue(jsonArray, values[i]);
		 	break;
		 case "BOOLEAN":
		 	createBooleanValue(jsonArray, values[i]);
		 	break;
		 case "OBJECT":
		 	createObjectValue(jsonArray, values[i]);
		 	break;
		 case "ARRAY":
		 	createArrayValue(jsonArray, values[i]);
		}
	}
	return JSON.stringify(jsonArray)
});

PW.Functions.register("toJsonArrayIterator", "string", ["function", "integer", "variable", "string"], 
	function(functionCall, maxTableLength, counter, type){
	var jsonArray = [];
	for (var i=0; i<maxTableLength; i++){
		counter.setValue(i);
		var value = functionCall.call();
		switch(type){
		 case "STRING":
		 	createStringValue(jsonArray, value);
		 	break;
		 case "INTEGER":
		 	createIntegerValue(jsonArray, value);
		 	break;
		 case "FLOAT":
		 	createDoubleValue(jsonArray, value);
		 	break;
		 case "BOOLEAN":
		 	createBooleanValue(jsonArray, value);
		 	break;
		 case "OBJECT":
		 	createObjectValue(jsonArray, value);
		 	break;
		 case "ARRAY":
		 	createArrayValue(jsonArray, value);
		}
	}
	return JSON.stringify(jsonArray)
});

PW.Functions.register("JSON.jsonPath", "string[]", ["string", "string"],
	function(text, path){
		let jsonPathPayload = { jsonText: text, jsonPath: path };
		return getJsonPathValues(jsonPathPayload);
});

PW.Functions.register("JSON.jsonPath", "string[]", ["string", "string", "string"],
	function(text, path, childNodeName){
		let jsonPathPayload = { jsonText: text, jsonPath: path, childNodeName: childNodeName }
		return getJsonPathValues(jsonPathPayload);
});

function getJsonPathValues(payload) {
	let result = [];
	jQuery.ajax({
		async: false,
		url: "plugin/com.suncode-cuf-components/json/jsonPath",
		method: "POST",
		contentType: "application/json",
		data: JSON.stringify(payload),
		success: function(response){
			result = response;
		},
		error: function (error) {
			Logger.error(error);
		}
	});
	return result;
}

function createStringField(jsonObject, key, value){
	if (isEmptyKey(key)){
		Logger.error("Entry key for value: " + value + " cannot be empty or null");
		throw new Error();
	}
	jsonObject[key] = value;
};

function createIntegerField(jsonObject, key, value){
	if (isEmptyKey(key)){
		Logger.error("Entry key for value: " + value + " cannot be empty or null");
		throw new Error();
	}
	var integerValue = Number(value);
	jsonObject[key] = integerValue;
};

function createDoubleField(jsonObject, key, value){
	if (isEmptyKey(key)){
		Logger.error("Entry key for value: " + value + " cannot be empty or null");
		throw new Error();
	}
	var doubleValue = Number(value);
	jsonObject[key] = doubleValue;
};

function createBooleanField(jsonObject, key, value){
	if (isEmptyKey(key)){
		Logger.error("Entry key for value: " + value + " cannot be empty or null");
		throw new Error();
	}
	jsonObject[key] = parseBoolean(value);
};

function createObjectField(jsonObject, key, value){
	if (isEmptyKey(key)){
		Logger.error("Entry key for value: " + value + " cannot be empty or null");
		throw new Error();
	}
	var objectValue = JSON.parse(value);
	jsonObject[key] = objectValue;
};

function createArrayField(jsonObject, key, value){
	if (isEmptyKey(key)){
		Logger.error("Entry key for value: " + value + " cannot be empty or null");
		throw new Error();
	}
	var arrayValue = JSON.parse(value);
	jsonObject[key] = arrayValue;
};

function createStringValue(jsonArray, value){
	jsonArray.push(value);
};

function createIntegerValue(jsonArray, value){
	var integerValue = Number(value);
	jsonArray.push(integerValue);
};

function createDoubleValue(jsonArray, value){
	var doubleValue = Number(value);
	jsonArray.push(doubleValue);
};

function createBooleanValue(jsonArray, value){
	jsonArray.push(parseBoolean(value));
};

function createObjectValue(jsonArray, value){
	var objectValue = JSON.parse(value);
	jsonArray.push(objectValue);
};

function createArrayValue(jsonArray, value){
	var arrayValue = JSON.parse(value);
	jsonArray.push(arrayValue);
};

function isEmptyKey(key){
	return (!key || key.length === 0 );
}