PW.Functions.register("filter", "string[]", ["string[]", "variable[]", "string[]", "string[]", "variable[]", "string[]", "variable[]",],
        function (array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues) {
    return getFilteredArray(array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues);
});

PW.Functions.register("filter", "integer[]", ["integer[]", "variable[]", "string[]", "string[]", "variable[]", "string[]", "variable[]",],
        function (array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues) {
    return getFilteredArray(array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues);
});

PW.Functions.register("filter", "float[]", ["float[]", "variable[]", "string[]", "string[]", "variable[]", "string[]", "variable[]",],
        function (array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues) {
    return getFilteredArray(array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues);
});

PW.Functions.register("filter", "date[]", ["date[]", "variable[]", "string[]", "string[]", "variable[]", "string[]", "variable[]",],
        function (array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues) {
    return getFilteredArray(array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues);
});

PW.Functions.register("filter", "datetime[]", ["datetime[]", "variable[]", "string[]", "string[]", "variable[]", "string[]", "variable[]",],
        function (array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues) {
    return getFilteredArray(array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues);
});

PW.Functions.register("boolean", "boolean[]", ["datetime[]", "variable[]", "string[]", "string[]", "variable[]", "string[]", "variable[]",],
        function (array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues) {
    return getFilteredArray(array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues);
});

PW.Functions.register("getSelectedRowNo", "integer", ["string"],
		function(tableId) {
	return getSelectedRowNumber(tableId);
});

PW.Functions.register("getSelectedRowIndex", "integer", ["string"],
    function(tableId) {
        return getSelectedRowIndex(tableId);
    });

function getSelectedRowNumber(tableId){
	try {
		var table = VariableSetService.get(tableId);
		var selectedRowNumber = VariableSetService.getRowIndex(table, VariableSetService.getSelected(table));
		return selectedRowNumber;
	} catch (err){
		Logger.error("Table with id: " + tableId + " not found.");
		return null;
	}
}

function getSelectedRowIndex(tableId){
    try {
        let table = VariableSetService.get(tableId);
        let selectedRowIndex = VariableSetService.getSelectedRowNo(table, VariableSetService.getSelected(table));
        return selectedRowIndex;
    } catch (err){
        Logger.error("Table with id: " + tableId + " not found.");
        return null;
    }
}

function getFilteredArray(array, singleFilterColumns, singleComparator, singleValues, multiFilterColumns, multiComparator, multipleValues){
    var rowsToFilterOut = filterColumnWithSingleValue(singleFilterColumns, singleComparator, singleValues, array.length);
    rowsToFilterOut = filterColumnWithMultipleValues(multiFilterColumns, multiComparator, multipleValues, rowsToFilterOut, array.length);
    var resultList = [];
    for (var i = 0; i < array.length; i++){
        if (!rowsToFilterOut[i]) resultList.push( array[i] );
    }
    return resultList;
}

function filterColumnWithSingleValue(singleFilterColumns, singleComparator, singleValues, length){
    var rowsToFilterOut = new Array(length);
    if (singleFilterColumns == null || singleFilterColumns.length == 0) return rowsToFilterOut;
    for (var i = 0; i < singleFilterColumns.length; i++)
    {
        var valueType = CUFCommon.getSingleType(singleFilterColumns[i].getType());
        var singleFilterValue = CUFCommon.stringToObject( singleValues[i], valueType );
        if (singleFilterColumns[i].getType().is("date[]")){
            singleFilterValue = PW.isEmpty(singleFilterValue) ? null : singleFilterValue.getTime();
        }
        for (var rowNumber = 0; rowNumber < length; rowNumber++)
        {
            var valueFromVariable = singleFilterColumns[i].getValue()[rowNumber];
            if (singleFilterColumns[i].getType().is("date[]")){
                valueFromVariable = PW.isEmpty(valueFromVariable) ? null : valueFromVariable.getTime();
            }
            if (!compareObjects[singleComparator[i]](valueFromVariable, singleFilterValue)){
                rowsToFilterOut[rowNumber] = true;
            }
        }
    }
    return rowsToFilterOut;
}

function filterColumnWithMultipleValues(multiFilterColumns, multiComparator, multipleValues, rowsToFilterOut){
    if (multiFilterColumns == null){
        return rowsToFilterOut;
    }
    for ( var i = 0; i < multiFilterColumns.length; i++)
    {
        if (multiFilterColumns[i].getType() != multipleValues[i].getType())
        {
            Logger.error("Columns in " + i + " row of function filter aren't the same type!");
        }
        for (var rowNumber = 0; rowNumber < rowsToFilterOut.length; rowNumber++)
        {
            var valueToCompare = multiFilterColumns[i].getValue()[rowNumber];
            var valueToCompareWith = multipleValues[i].getValue()[rowNumber];
            if (multiFilterColumns[i].getType().is("date[]")){
                valueToCompare = PW.isEmpty(valueToCompare) ? null : valueToCompare.getTime();
                valueToCompareWith = PW.isEmpty(valueToCompareWith)  ? null : valueToCompareWith.getTime();
            }
            if (!compareObjects[multiComparator[i]](valueToCompare, valueToCompareWith))
            {
                rowsToFilterOut[rowNumber] = true;
            }
        }
    }
    return rowsToFilterOut;
}

var compareObjects = {
    "=": function(cellValue, expectedValue) { return cellValue == expectedValue },
    "!=": function(cellValue, compareValue) { return cellValue != compareValue },
    "<": function(cellValue, compareValue) { return cellValue < compareValue },
    ">": function(cellValue, compareValue) { return cellValue > compareValue },
    "<=": function(cellValue, compareValue) { return cellValue <= compareValue },
    ">=": function(cellValue, compareValue) { return cellValue >= compareValue },
    "regex": function(cellValue, pattern) {
        let regExp = new RegExp(pattern, "u");
        return regExp.test(cellValue)
    }
};