/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.user.validators;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.user.UserDataService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import org.springframework.beans.factory.annotation.Autowired;

@Validator
public class UserRoleCheckerValidator {
    @Autowired
    private UserDataService userService;

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("user-role-validator")).name("validator.user_role.name")).description("validator.user_role.desc")).category(new Category[]{Categories.USER})).documentationLink("confluence/x/J4TK")).icon((Icon)SilkIconPack.USER_FEMALE)).parameter().id("userName").name("application.user-role.username.name").type((Type)Types.STRING).create()).parameter().id("roleId").name("application.user-role.roleId.name").description("application.user-role.roleId.desc").type((Type)Types.STRING).create()).parameter().id("searchInPackage").name("application.user-role.package.name").description("application.user-role.package.desc").type((Type)Types.BOOLEAN).create()).parameter().id("confirmation").name("validator.confirm_param.name_default").description("validator.confirm_param.desc_default").type((Type)Types.BOOLEAN).create()).parameter().id("alert").name("validator.alert_param.name_default").description("validator.alert_param.desc_default").type((Type)Types.STRING).create();
    }

    public void validate(@Param String userName, @Param String roleId, @Param Boolean searchInPackage, @Param Boolean confirmation, @Param String alert, ValidationErrors errors, Translator translator, ValidationContext context) {
        boolean hasRole = this.userService.doesUserHaveRole(userName, roleId, context.getProcessId(), searchInPackage);
        if (!hasRole) {
            if (confirmation.booleanValue()) {
                errors.addConfirmation(alert, translator.getMessage("validator.title_default"));
            } else {
                errors.add(alert);
            }
        }
    }
}

