/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.tablestore.functions;

import com.google.common.math.BigIntegerMath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class AggregateFunctionsUtil {
    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");

    public static String concat(List<Object> valuesToAggregate, String concatSeparator) {
        return valuesToAggregate.isEmpty() ? "" : valuesToAggregate.stream().map(object -> (String)object).collect(Collectors.joining(concatSeparator));
    }

    public static Object sum(List<Object> valuesToAggregate) {
        if (valuesToAggregate.isEmpty()) {
            return null;
        }
        Object obj = valuesToAggregate.get(0);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            return valuesToAggregate.stream().map(number -> BigInteger.valueOf((Long)number)).reduce(BigInteger.ZERO, BigInteger::add);
        }
        if (obj instanceof Double) {
            return valuesToAggregate.stream().map(number -> BigDecimal.valueOf((Double)number)).reduce(BigDecimal.ZERO, BigDecimal::add).stripTrailingZeros();
        }
        return 0;
    }

    public static Object min(List<Object> valuesToAggregate) {
        if (valuesToAggregate.isEmpty()) {
            return null;
        }
        Optional<Object> optionalObj = valuesToAggregate.stream().filter(Objects::nonNull).findFirst();
        if (!optionalObj.isPresent()) {
            return null;
        }
        if (optionalObj.get() instanceof Long) {
            return valuesToAggregate.stream().mapToLong(number -> (Long)number).min().getAsLong();
        }
        if (optionalObj.get() instanceof Double) {
            return valuesToAggregate.stream().mapToDouble(number -> (Double)number).min().getAsDouble();
        }
        if (optionalObj.get() instanceof LocalDate) {
            return valuesToAggregate.stream().filter(date -> date != null).map(date -> (LocalDate)date).min(LocalDate::compareTo).map(date -> date.toString(formatter)).get();
        }
        return null;
    }

    public static Object max(List<Object> valuesToAggregate) {
        if (valuesToAggregate.isEmpty()) {
            return null;
        }
        Optional<Object> optionalObj = valuesToAggregate.stream().filter(Objects::nonNull).findFirst();
        if (!optionalObj.isPresent()) {
            return null;
        }
        if (optionalObj.get() instanceof Long) {
            return valuesToAggregate.stream().filter(Objects::nonNull).mapToLong(number -> (Long)number).max().getAsLong();
        }
        if (optionalObj.get() instanceof Double) {
            return valuesToAggregate.stream().filter(Objects::nonNull).mapToDouble(number -> (Double)number).max().getAsDouble();
        }
        if (optionalObj.get() instanceof LocalDate) {
            return valuesToAggregate.stream().filter(Objects::nonNull).map(date -> (LocalDate)date).max(LocalDate::compareTo).map(date -> date.toString(formatter)).get();
        }
        return null;
    }

    public static Object avg(List<Object> valuesToAggregate, String decimalPlaces) {
        if (valuesToAggregate.isEmpty()) {
            return null;
        }
        Optional<Object> optionalObj = valuesToAggregate.stream().filter(Objects::nonNull).findFirst();
        if (!optionalObj.isPresent()) {
            return null;
        }
        if (optionalObj.get() instanceof Long) {
            BigInteger sum = valuesToAggregate.stream().filter(Objects::nonNull).map(number -> BigInteger.valueOf((Long)number)).reduce(BigInteger.ZERO, BigInteger::add);
            return BigIntegerMath.divide((BigInteger)sum, (BigInteger)BigInteger.valueOf(valuesToAggregate.size()), (RoundingMode)RoundingMode.HALF_UP);
        }
        if (optionalObj.get() instanceof Double) {
            BigDecimal sum = valuesToAggregate.stream().filter(Objects::nonNull).map(number -> BigDecimal.valueOf((Double)number)).reduce(BigDecimal.ZERO, BigDecimal::add);
            return sum.divide(BigDecimal.valueOf(valuesToAggregate.size()), Integer.parseInt(decimalPlaces), RoundingMode.HALF_UP);
        }
        return null;
    }

    public static Long count(List<Object> valuesToAggregate) {
        if (valuesToAggregate.isEmpty()) {
            return null;
        }
        Optional<Object> optionalObj = valuesToAggregate.stream().filter(Objects::nonNull).findFirst();
        if (!optionalObj.isPresent() || optionalObj.get() instanceof LocalDate) {
            return null;
        }
        return valuesToAggregate.stream().count();
    }
}

