/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.tablestore;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.suncode.cuf.common.tablestore.TableStore;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class TableStoreDeserializer
implements JsonDeserializer<TableStore> {
    private static final Gson gson = new GsonBuilder().serializeNulls().create();

    public TableStore deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Map variableType = (Map)gson.fromJson((JsonElement)json.getAsJsonObject().get("variableType").getAsJsonObject(), new TypeToken<Map<String, String>>(){}.getType());
        JsonArray dataAsJsonArray = json.getAsJsonObject().get("data").getAsJsonArray();
        List<Map<String, Object>> data = StreamSupport.stream(dataAsJsonArray.spliterator(), true).map(jsonRecord -> {
            HashMap record = new HashMap();
            jsonRecord.getAsJsonObject().entrySet().stream().forEach(jsonProperty -> record.put(jsonProperty.getKey(), this.resolveType((String)variableType.get(jsonProperty.getKey()), (JsonElement)jsonProperty.getValue())));
            return record;
        }).collect(Collectors.toList());
        TableStore tableStore = new TableStore();
        variableType.entrySet().stream().forEach(entry -> tableStore.getVariableType().put((String)entry.getKey(), (String)entry.getValue()));
        tableStore.setData(data);
        return tableStore;
    }

    private Object resolveType(String type, JsonElement element) {
        switch (type) {
            case "date": 
            case "string": {
                return element.isJsonNull() ? null : element.getAsString();
            }
            case "float": {
                return element.getAsDouble();
            }
            case "integer": {
                return element.getAsLong();
            }
        }
        throw new IllegalArgumentException("Wrong type \"" + type + "\" provided into TableStore!");
    }
}

