/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.table.duals;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.cuf.common.utils.LogUtils;
import com.suncode.cuf.common.utils.handlers.ApplicationCommentHandler;
import com.suncode.cuf.common.utils.handlers.ErrorHandlersExecution;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
public class SetColumnDual {
    private static final Logger log = LoggerFactory.getLogger(SetColumnDual.class);
    @Autowired
    CommentService commentService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("set-row-dual")).name("dual-app-set.set-row-dual.name")).description("dual-app-set.set-row-dual.desc")).category(new Category[]{Categories.TABLE})).documentationLink("confluence/x/pIXK")).icon((Icon)SilkIconPack.TABLE_EDIT)).contextVariable().id("currentRow").name("dual-app-set.set-row-dual.currentRow.name").type((Type)Types.INTEGER).create().parameter().id("value").name("dual-app-set.set-row-dual.value.name").description("dual-app-set.set-row-dual.value.desc").type((Type)Types.FUNCTION).create()).parameter().id("column").name("dual-app-set.set-row-dual.column.name").type((Type)Types.VARIABLE).create()).parameter().id("values").name("dual-app-set.set-row-dual.values.name").description("dual-app-set.set-row-dual.values.desc").type((Type)Types.FUNCTION_ARRAY).optional().create()).parameter().id("columns").name("dual-app-set.set-row-dual.columns.name").description("dual-app-set.set-row-dual.columns.desc").type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("condition").name("dual-app-set.set-row-dual.condition.name").description("dual-app-set.set-row-dual.condition.desc").type((Type)Types.FUNCTION).optional().create()).parameter().id("commentError").name("application.database.defaults.comment_error.name").description("application.database.defaults.comment_error.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create();
    }

    public void execute(ApplicationContext context, Parameters parameters, ContextVariables contextVariables) throws Exception {
        try {
            this.setValues(parameters, contextVariables, (WorkflowContext)context);
        }
        catch (Exception e) {
            Boolean commentError = (Boolean)parameters.get("commentError", Boolean.class);
            if (Boolean.FALSE.equals(commentError)) {
                throw e;
            }
            ApplicationCommentHandler handler = new ApplicationCommentHandler(this.commentService, context.getProcessId(), context.getActivityId(), e);
            ErrorHandlersExecution handlerExecution = new ErrorHandlersExecution(e, handler);
            handlerExecution.handle();
        }
    }

    public void set(Parameters parameters, ContextVariables contextVariables, AcceptanceContext context) throws Exception {
        try {
            this.setValues(parameters, contextVariables, (WorkflowContext)context);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw e;
        }
    }

    private void setValues(Parameters parameters, ContextVariables contextVariables, WorkflowContext context) throws IllegalArgumentException {
        LogUtils logUtils = new LogUtils(context);
        FunctionCall condition = (FunctionCall)parameters.get("condition", FunctionCall.class);
        FunctionCall value = (FunctionCall)parameters.get("value", FunctionCall.class);
        Object[] values = (FunctionCall[])parameters.get("values", FunctionCall[].class);
        Variable column = (Variable)parameters.get("column", Variable.class);
        Object[] columns = (Variable[])parameters.get("columns", Variable[].class);
        if (columns.length != values.length) {
            throw new IllegalArgumentException("Array sizes are not equal!");
        }
        FunctionCall[] allValues = (FunctionCall[])ArrayUtils.addAll((Object[])new FunctionCall[]{value}, (Object[])values);
        Variable[] allColumns = (Variable[])ArrayUtils.addAll((Object[])new Variable[]{column}, (Object[])columns);
        this.setColumns(allValues, allColumns, condition, contextVariables, logUtils);
    }

    private void setColumns(FunctionCall[] values, Variable[] columns, FunctionCall condition, ContextVariables contextVariables, LogUtils logUtils) throws IllegalArgumentException {
        IntStream.range(0, columns.length).forEach(index -> this.setColumn(values[index], columns[index], condition, contextVariables, logUtils));
    }

    private void setColumn(FunctionCall value, Variable column, FunctionCall condition, ContextVariables contextVariables, LogUtils logUtils) {
        Object[] valuesInColumn = (Object[])column.getValue();
        long numberOfFuncCalls = 0L;
        for (int i = 0; i < valuesInColumn.length; ++i) {
            logUtils.disableLoggingIfLimitReached(numberOfFuncCalls++);
            contextVariables.set("currentRow", (Object)i);
            logUtils.debug("Check condition for index  " + i);
            if (!this.checkCondition(condition)) continue;
            logUtils.disableLoggingIfLimitReached(numberOfFuncCalls++);
            logUtils.debug("Update column Values of index " + i);
            this.updateColumnValues(i, valuesInColumn, value, column);
        }
        column.setValue((Object)valuesInColumn);
    }

    private boolean checkCondition(FunctionCall condition) {
        if (condition == null) {
            return true;
        }
        Type type = condition.getReturnType();
        Assert.isTrue((type == null || type == Types.BOOLEAN ? 1 : 0) != 0, (String)"Wrong type of returned function value in 'condition' parameter.");
        return (Boolean)condition.call();
    }

    private void updateColumnValues(int i, Object[] valuesInColumn, FunctionCall value, Variable column) {
        Assert.isTrue((value != null ? 1 : 0) != 0, (String)"Empty function value to set is not accepted!");
        Type type = value.getReturnType();
        Assert.isTrue((type == DataConverter.getSingleType(column.getType()) ? 1 : 0) != 0, (String)("Wrong type of returned function value in 'value' parameter with index: " + i + " while trying to set column with id: " + column.getId() + "."));
        valuesInColumn[i] = value.call();
    }
}

