/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.scheduledtasks.servlets;

import com.plusmpm.database.scheduledTasks.ScheduledTasksMethods;
import com.suncode.cuf.common.scheduledtasks.services.ScheduledTaskService;
import com.suncode.pwfl.search.CountedResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/scheduled-tasks"})
public class ScheduledTasksController {
    @Autowired
    private ScheduledTaskService scheduledTaskService;

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    public CountedResult<Map<String, String>> getAll() {
        List allScheduledTasks = ScheduledTasksMethods.getAllScheduledTasks();
        List scheduledTaskNames = allScheduledTasks.stream().map(task -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", task.getName());
            return map;
        }).collect(Collectors.toList());
        return new CountedResult((long)scheduledTaskNames.size(), scheduledTaskNames);
    }

    @RequestMapping(value={"/run"}, method={RequestMethod.POST})
    public ResponseEntity<String> run(@RequestParam(value="taskName") String taskName) {
        try {
            ScheduledTaskService.ScheduledTaskExecutionResult result = this.scheduledTaskService.executeScheduledTask(taskName);
            if ("ok".equals(result.getStatus())) {
                return new ResponseEntity((Object)result.getResponse(), HttpStatus.OK);
            }
            return new ResponseEntity((Object)result.getResponse(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

