/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.functions;

import com.suncode.pwfl.core.function.Function;
import com.suncode.pwfl.core.function.annotation.Function;
import com.suncode.pwfl.core.function.annotation.Functions;
import com.suncode.pwfl.core.function.annotation.FunctionsScript;
import com.suncode.pwfl.core.type.BasicTypes;
import com.suncode.pwfl.workflow.variable.Variable;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.apache.commons.lang.ArrayUtils;
import org.joda.time.LocalDate;

@Functions
@FunctionsScript(value="/functions/general-functions.js")
public class GeneralFunctions {
    @Function
    public int currentYear() {
        Calendar cal = Calendar.getInstance();
        return cal.get(1);
    }

    @Function
    public String[] intersect(String[] arr1, String[] arr2) {
        Object[] objArray = this.getIntersect(arr1, arr2);
        return (String[])Arrays.copyOf(objArray, objArray.length, String[].class);
    }

    @Function
    public Long[] intersect(Long[] arr1, Long[] arr2) {
        Object[] objArray = this.getIntersect(arr1, arr2);
        return (Long[])Arrays.copyOf(objArray, objArray.length, Long[].class);
    }

    @Function
    public Double[] intersect(Double[] arr1, Double[] arr2) {
        Object[] objArray = this.getIntersect(arr1, arr2);
        return (Double[])Arrays.copyOf(objArray, objArray.length, Double[].class);
    }

    @Function
    public LocalDate[] intersect(LocalDate[] arr1, LocalDate[] arr2) {
        Object[] objArray = this.getIntersect(arr1, arr2);
        return (LocalDate[])Arrays.copyOf(objArray, objArray.length, LocalDate[].class);
    }

    @Function
    public String[] except(String[] arr1, String[] arr2) {
        Object[] objArray = this.getExcept(arr1, arr2);
        return (String[])Arrays.copyOf(objArray, objArray.length, String[].class);
    }

    @Function
    public Long[] except(Long[] arr1, Long[] arr2) {
        Object[] objArray = this.getExcept(arr1, arr2);
        return (Long[])Arrays.copyOf(objArray, objArray.length, Long[].class);
    }

    @Function
    public Double[] except(Double[] arr1, Double[] arr2) {
        Object[] objArray = this.getExcept(arr1, arr2);
        return (Double[])Arrays.copyOf(objArray, objArray.length, Double[].class);
    }

    @Function
    public LocalDate[] except(LocalDate[] arr1, LocalDate[] arr2) {
        Object[] objArray = this.getExcept(arr1, arr2);
        return (LocalDate[])Arrays.copyOf(objArray, objArray.length, LocalDate[].class);
    }

    @Function
    public String[] union(String[] arr1, String[] arr2) {
        Object[] objArray = this.getUnion(arr1, arr2);
        return (String[])Arrays.copyOf(objArray, objArray.length, String[].class);
    }

    @Function
    public Long[] union(Long[] arr1, Long[] arr2) {
        Object[] objArray = this.getUnion(arr1, arr2);
        return (Long[])Arrays.copyOf(objArray, objArray.length, Long[].class);
    }

    @Function
    public Double[] union(Double[] arr1, Double[] arr2) {
        Object[] objArray = this.getUnion(arr1, arr2);
        return (Double[])Arrays.copyOf(objArray, objArray.length, Double[].class);
    }

    @Function
    public LocalDate[] union(LocalDate[] arr1, LocalDate[] arr2) {
        Object[] objArray = this.getUnion(arr1, arr2);
        return (LocalDate[])Arrays.copyOf(objArray, objArray.length, LocalDate[].class);
    }

    @Function
    public String[] symmetricDifference(String[] arr1, String[] arr2) {
        Object[] objArray = this.getSymDifference(arr1, arr2);
        return (String[])Arrays.copyOf(objArray, objArray.length, String[].class);
    }

    @Function
    public Long[] symmetricDifference(Long[] arr1, Long[] arr2) {
        Object[] objArray = this.getSymDifference(arr1, arr2);
        return (Long[])Arrays.copyOf(objArray, objArray.length, Long[].class);
    }

    @Function
    public Double[] symmetricDifference(Double[] arr1, Double[] arr2) {
        Object[] objArray = this.getSymDifference(arr1, arr2);
        return (Double[])Arrays.copyOf(objArray, objArray.length, Double[].class);
    }

    @Function
    public LocalDate[] symmetricDifference(LocalDate[] arr1, LocalDate[] arr2) {
        Object[] objArray = this.getSymDifference(arr1, arr2);
        return (LocalDate[])Arrays.copyOf(objArray, objArray.length, LocalDate[].class);
    }

    @Function
    public String[] unionAll(String[] arr1, String[] arr2) {
        return this.getUnionAll(arr1, arr2);
    }

    @Function
    public Long[] unionAll(Long[] arr1, Long[] arr2) {
        return this.getUnionAll(arr1, arr2);
    }

    @Function
    public Double[] unionAll(Double[] arr1, Double[] arr2) {
        return this.getUnionAll(arr1, arr2);
    }

    @Function
    public LocalDate[] unionAll(LocalDate[] arr1, LocalDate[] arr2) {
        return this.getUnionAll(arr1, arr2);
    }

    @Function
    public String[] distinct(String[] array) {
        Object[] objArray = this.getDistinct(array);
        return (String[])Arrays.copyOf(objArray, objArray.length, String[].class);
    }

    @Function
    public Long[] distinct(Long[] array) {
        Object[] objArray = this.getDistinct(array);
        return (Long[])Arrays.copyOf(objArray, objArray.length, Long[].class);
    }

    @Function
    public Double[] distinct(Double[] array) {
        Object[] objArray = this.getDistinct(array);
        return (Double[])Arrays.copyOf(objArray, objArray.length, Double[].class);
    }

    @Function
    public LocalDate[] distinct(LocalDate[] array) {
        Object[] objArray = this.getDistinct(array);
        return (LocalDate[])Arrays.copyOf(objArray, objArray.length, LocalDate[].class);
    }

    @Function
    public String replaceMany(String orginalString, String replaceOptions, String[] replaceFrom, String replaceTo) {
        if (replaceOptions.equals("WINDOWS")) {
            replaceFrom = new String[]{"<", ">", ":", "\"", "/", "|", "\\", "?", "*"};
        }
        if (replaceOptions.equals("LINUX")) {
            replaceFrom = new String[]{"/"};
        }
        for (String str : replaceFrom) {
            orginalString = orginalString.replace(str, replaceTo);
        }
        return orginalString;
    }

    @Function
    public String replaceDiacritics(String text) {
        String nfdNormalizedString = Normalizer.normalize(text, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(nfdNormalizedString).replaceAll("").replace("\u0142", "l").replace("\u0141", "L").replace("\u0110", "D").replace("\u0111", "d").replace("\u00d8", "O").replace("\u00f8", "o");
    }

    @Function
    public String getId(Variable variable) {
        return variable.getId();
    }

    @Function
    public String[] createStringArray(int length) {
        return this.createStringArray(length, this.getDefaultValue(String.class));
    }

    @Function
    public Long[] createIntegerArray(int length) {
        return this.createIntegerArray(length, this.getDefaultValue(Long.class));
    }

    @Function
    public Double[] createFloatArray(int length) {
        return this.createFloatArray(length, this.getDefaultValue(Double.class));
    }

    @Function
    public LocalDate[] createDateArray(int length) {
        return this.createDateArray(length, this.getDefaultValue(LocalDate.class));
    }

    @Function
    public String[] createStringArray(int length, String initialValue) {
        return (String[])IntStream.range(0, length).mapToObj(i -> initialValue).toArray(String[]::new);
    }

    @Function
    public Long[] createIntegerArray(int length, Long initialValue) {
        return (Long[])IntStream.range(0, length).mapToObj(i -> initialValue).toArray(Long[]::new);
    }

    @Function
    public Double[] createFloatArray(int length, Double initialValue) {
        return (Double[])IntStream.range(0, length).mapToObj(i -> initialValue).toArray(Double[]::new);
    }

    @Function
    public LocalDate[] createDateArray(int length, LocalDate initialValue) {
        return (LocalDate[])IntStream.range(0, length).mapToObj(i -> initialValue).toArray(LocalDate[]::new);
    }

    @Function(accessibility=Function.FunctionAccessibility.BROWSER)
    public Boolean isProcessedTable(String tableId) {
        return null;
    }

    @Function
    public Boolean isEUCountry(String countryCode) {
        return Arrays.stream(this.getEuropeanUnionCountryCodes()).anyMatch(code -> code.equalsIgnoreCase(countryCode));
    }

    @Function(accessibility=Function.FunctionAccessibility.BROWSER)
    public String getNextSequenceValue(String format, String sequenceName) {
        return "";
    }

    private <T> Object[] getIntersect(T[] arr1, T[] arr2) {
        LinkedHashSet<Object> set1 = new LinkedHashSet<Object>(Arrays.asList(arr1));
        LinkedHashSet<T> set2 = new LinkedHashSet<T>(Arrays.asList(arr2));
        set1.retainAll(set2);
        return set1.toArray(new Object[set1.size()]);
    }

    private <T> Object[] getExcept(T[] arr1, T[] arr2) {
        LinkedHashSet<Object> set1 = new LinkedHashSet<Object>(Arrays.asList(arr1));
        LinkedHashSet<T> set2 = new LinkedHashSet<T>(Arrays.asList(arr2));
        set1.removeAll(set2);
        return set1.toArray(new Object[set1.size()]);
    }

    private <T> Object[] getUnion(T[] arr1, T[] arr2) {
        LinkedHashSet<Object> set1 = new LinkedHashSet<Object>(Arrays.asList(arr1));
        LinkedHashSet<T> set2 = new LinkedHashSet<T>(Arrays.asList(arr2));
        set1.addAll(set2);
        return set1.toArray(new Object[set1.size()]);
    }

    private <T> Object[] getSymDifference(T[] arr1, T[] arr2) {
        LinkedHashSet<Object> set1 = new LinkedHashSet<Object>(Arrays.asList(this.getExcept(arr1, arr2)));
        LinkedHashSet<Object> set2 = new LinkedHashSet<Object>(Arrays.asList(this.getExcept(arr2, arr1)));
        set1.addAll(set2);
        return set1.toArray(new Object[set1.size()]);
    }

    private <T> T[] getUnionAll(T[] arr1, T[] arr2) {
        return ArrayUtils.addAll((Object[])arr1, (Object[])arr2);
    }

    private <T> Object[] getDistinct(T[] array) {
        LinkedHashSet<T> set = new LinkedHashSet<T>(Arrays.asList(array));
        return set.toArray();
    }

    private <T> T getDefaultValue(Class<T> elementType) {
        return elementType.cast(BasicTypes.of(elementType).defaultValue());
    }

    private String[] getEuropeanUnionCountryCodes() {
        return new String[]{"AT", "BE", "BG", "HR", "CY", "CZ", "DK", "EE", "FI", "FR", "GR", "ES", "IE", "LT", "LU", "LV", "MT", "NL", "DE", "PL", "PT", "RO", "SK", "SI", "SE", "HU", "IT"};
    }
}

