/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.applications;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.utils.SequenceGenerator;
import com.suncode.cuf.common.utils.handlers.ApplicationCommentHandler;
import com.suncode.cuf.common.utils.handlers.ErrorHandlersExecution;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.database.sequence.SequenceService;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.variable.Variable;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-pwe/unique-sequence-number-form.js")
public class UniqueSequenceNumberApp {
    @Autowired
    private SequenceService sequenceService;
    @Autowired
    private CommentService commentService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("sequenced-no-gen")).name("application.processdoc.set_seq_no.name")).description("application.processdoc.set_seq_no.name")).category(new Category[]{Categories.GENERAL})).icon((Icon)SilkIconPack.TAG_BLUE_ADD)).documentationLink("confluence/x/v4PK")).parameter().id("format").name("application.processdoc.set_seq_no.format_param.name").description("application.processdoc.set_seq_no.format_param.desc").defaultValue((Object)"[N4]/[R2]").type((Type)Types.STRING).create()).parameter().id("sequenceName").name("application.processdoc.set_seq_no.name_param.name").description("application.processdoc.set_seq_no.name_param.desc").type((Type)Types.STRING).optional().create()).parameter().id("targetVariable").name("application.processdoc.set_seq_no.target_param.name").description("application.processdoc.set_seq_no.target_param.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("commentError").name("application.processdoc.set_seq_no.error-msg.name").description("application.processdoc.set_seq_no.error-msg.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("specialCharacters").name("application.processdoc.set_seq_no.special-chars_param.name").description("application.processdoc.set_seq_no.special-chars_param.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create();
    }

    public void execute(ApplicationContext context, @Param String format, @Param String sequenceName, @Param Variable targetVariable, @Param Boolean commentError, @Param Boolean specialCharacters, Translator translator) throws Exception {
        this.run((WorkflowContext)context, format, sequenceName, targetVariable, commentError, specialCharacters);
    }

    public void set(AcceptanceContext context, @Param String format, @Param String sequenceName, @Param Variable targetVariable, @Param Boolean commentError, @Param Boolean specialCharacters, Translator translator) throws Exception {
        this.run((WorkflowContext)context, format, sequenceName, targetVariable, commentError, specialCharacters);
    }

    private void run(WorkflowContext context, String format, String sequenceName, Variable targetVariable, Boolean commentError, Boolean specialCharacters) throws Exception {
        try {
            if (specialCharacters.booleanValue()) {
                sequenceName = sequenceName.replaceAll("[^a-zA-Z0-9]", "_");
            }
            SequenceGenerator sequenceGenerator = new SequenceGenerator(format, sequenceName, this.sequenceService);
            targetVariable.setValue((Object)sequenceGenerator.generate());
        }
        catch (Exception e) {
            if (!commentError.booleanValue()) {
                throw e;
            }
            ApplicationCommentHandler handler = new ApplicationCommentHandler(this.commentService, context.getProcessId(), context.getActivityId(), e);
            ErrorHandlersExecution handlerExecution = new ErrorHandlersExecution(e, handler);
            handlerExecution.handle();
        }
    }
}

