/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.libreoffice.services;

import com.sun.star.beans.PropertyValue;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.suncode.cuf.common.documents.libreoffice.exceptions.LibreOfficeInitializationException;
import com.suncode.cuf.common.documents.libreoffice.exceptions.LibreOfficeInvalidLicenceException;
import com.suncode.cuf.common.documents.libreoffice.exceptions.LibreOfficeNotFoundException;
import com.suncode.cuf.common.documents.libreoffice.services.LibreOfficeService;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginFramework;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import ooo.connector.BootstrapSocketConnector;
import ooo.connector.server.OOoServer;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LibreOfficeServiceImpl
implements LibreOfficeService {
    private static final Logger log = LoggerFactory.getLogger(LibreOfficeServiceImpl.class);
    private static final String[] SUPPORTED_MIME_TYPES = new String[]{"application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/msword", "text/csv", "application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.spreadsheet", "application/rtf", "application/vnd.ms-powerpoint", "application/vnd.ms-excel", "application/vnd.oasis.opendocument.presentation", "text/plain", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"};
    private static final List<String> CONNECTION_OPTIONS = Arrays.asList("--headless", "--nofirststartwizard", "--nologo", "--nodefault", "--norestore", "--nocrashreport", "--nolockcheck");
    private final Tika tika = new Tika();
    private XComponent xComp = null;
    private XDesktop xDesktop = null;
    private boolean success = false;
    private BootstrapSocketConnector bootstrapSocketConnector;
    @Autowired
    private PluginFramework pluginFramework;

    private static PropertyValue[] createPropertyValue(String[] names, Object[] values) {
        if (names.length != values.length) {
            return new PropertyValue[0];
        }
        PropertyValue[] propertyValue = new PropertyValue[names.length];
        IntStream.range(0, names.length).forEach(i -> {
            propertyValue[i] = new PropertyValue();
            propertyValue[i].Name = names[i];
            propertyValue[i].Value = values[i];
        });
        return propertyValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convertDocxToPdf(String inputDocumentPath, String outputDocumentPath) {
        try {
            String sourceDocumentPath = "file:///" + inputDocumentPath.replace('\\', '/');
            String destinationDocumentPath = outputDocumentPath.replace('\\', '/');
            XComponentLoader xCompLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)this.xDesktop);
            PropertyValue[] propertyValues = LibreOfficeServiceImpl.createPropertyValue(new String[]{"ReadOnly", "Hidden"}, new Object[]{Boolean.TRUE, Boolean.TRUE});
            this.xComp = xCompLoader.loadComponentFromURL(sourceDocumentPath, "_blank", 0, propertyValues);
            XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.xComp);
            propertyValues = LibreOfficeServiceImpl.createPropertyValue(new String[]{"Overwrite", "FilterName"}, new Object[]{Boolean.TRUE, "writer_pdf_Export"});
            xStorable.storeToURL("file:///" + destinationDocumentPath, propertyValues);
            this.success = true;
        }
        catch (com.sun.star.uno.Exception | RuntimeException e) {
            this.success = false;
            log.error("Error converting file: " + inputDocumentPath, e);
        }
        finally {
            this.xComp.dispose();
        }
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public boolean checkFileType(String filename) {
        File file = Paths.get(filename, new String[0]).toFile();
        return Arrays.stream(SUPPORTED_MIME_TYPES).anyMatch(allowedMimeType -> {
            try {
                return this.tika.detect(file).equalsIgnoreCase((String)allowedMimeType);
            }
            catch (IOException e) {
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkInstallation(String libreOfficePath) {
        if (StringUtils.isBlank((CharSequence)libreOfficePath)) {
            return false;
        }
        try {
            XComponentContext xContext = this.connect(libreOfficePath);
            XMultiComponentFactory xMCF = xContext.getServiceManager();
            boolean bl = xMCF != null;
            return bl;
        }
        catch (BootstrapException e) {
            log.error("LibreOffice installation check error!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.bootstrapSocketConnector.disconnect();
        }
    }

    @Override
    public boolean checkLicence(String libreOfficeLicencePluginKey) {
        Plugin plugin = this.pluginFramework.getPlugin(libreOfficeLicencePluginKey);
        return plugin != null && plugin.hasValidLicense();
    }

    @Override
    public void open() throws LibreOfficeNotFoundException, LibreOfficeInitializationException, LibreOfficeInvalidLicenceException {
        if (!this.checkLicence("com.suncode.plugin-libreoffice-integrator")) {
            throw new LibreOfficeInvalidLicenceException("Invalid LibreOffice Integrator licence!");
        }
        try {
            XComponentContext xContext = this.connect(SystemProperties.getString((String)"Installation.Path"));
            XMultiComponentFactory xMCF = xContext.getServiceManager();
            if (xMCF == null) {
                throw new LibreOfficeNotFoundException("Libre Office installation not found at given location!");
            }
            Object oDesktop = xMCF.createInstanceWithContext("com.sun.star.frame.Desktop", xContext);
            this.xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)oDesktop);
        }
        catch (BootstrapException | com.sun.star.uno.Exception e) {
            throw new LibreOfficeInitializationException("Libre Office initialization error!", (Exception)e);
        }
    }

    @Override
    public void close() {
        try {
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)this.xComp);
            if (xCloseable != null) {
                xCloseable.close(true);
            }
        }
        catch (CloseVetoException e) {
            log.error("LibreOffice closing error!", (Throwable)e);
        }
        finally {
            if (this.xDesktop != null) {
                this.xDesktop.terminate();
            }
            this.bootstrapSocketConnector.disconnect();
        }
    }

    private XComponentContext connect(String libreOfficePath) throws BootstrapException {
        String hostAndPort = "host=localhost,port=8100";
        String oooAcceptOption = "--accept=socket," + hostAndPort + ";urp;";
        String unoConnectString = "uno:socket," + hostAndPort + ";urp;StarOffice.ComponentContext";
        this.bootstrapSocketConnector = new BootstrapSocketConnector(new OOoServer(libreOfficePath, CONNECTION_OPTIONS));
        return this.bootstrapSocketConnector.connect(oooAcceptOption, unoConnectString);
    }
}

