/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.applications;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.cuf.common.Categories;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class RunDocumentClassAcion {
    private static Logger log = Logger.getLogger(RunDocumentClassAcion.class);
    @Autowired
    private DocumentClassActionService documentClassActionService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentClassService docClassService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("run-document-class-action-app")).name("application.run-document-class-action-app.name")).description("application.run-document-class-action-app.desc")).category(new Category[]{Categories.DOCUMENTS})).documentationLink("confluence/x/7YPK")).icon((Icon)SilkIconPack.APPLICATION_GO)).parameter().id("srcAction").name("application.run-document-class-action-app.src-action.name").description("application.run-document-class-action-app.src-action.desc").type((Type)Types.STRING).create()).parameter().id("documentClasses").name("application.run-document-class-action-app.document-class.name").type((Type)Types.STRING_ARRAY).create();
    }

    public void execute(ApplicationContext context, @Param String[] documentClasses, @Param String srcAction) throws Exception {
        DocumentEventTypes srcActionSet = this.getDocumentEventType(srcAction);
        List docs = this.documentFinder.getDocumentsFromProcess(context.getProcessId(), new String[0]);
        ArrayList<Long> classIdList = new ArrayList<Long>();
        for (String classIDString : documentClasses) {
            DocumentClass temp = this.docClassService.getDocumentClass(classIDString, new String[0]);
            Long classId = temp == null ? Long.valueOf(classIDString.trim()) : temp.getId();
            classIdList.add(classId);
        }
        for (WfDocument wfDocument : docs) {
            if (!classIdList.isEmpty() && !classIdList.contains(wfDocument.getDocumentClassId())) continue;
            log.debug((Object)("Run document action on wfDocument ID:" + wfDocument.getId()));
            this.documentClassActionService.executeProcessActions(wfDocument, srcActionSet, context.getProcessId(), context.getActivityId());
        }
    }

    private DocumentEventTypes getDocumentEventType(String srcAction) throws Exception {
        try {
            return DocumentEventTypes.valueOf((String)srcAction.toUpperCase().trim());
        }
        catch (Exception e) {
            log.debug((Object)("Invalid source action parameter\t" + srcAction + "\nPossible parameters:\t" + Arrays.toString(DocumentEventTypes.values())));
            throw e;
        }
    }
}

