/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.applications;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.documents.CUFCommonDocumentService;
import com.suncode.cuf.common.utils.TranslatorService;
import com.suncode.cuf.template.WordTemplateService;
import com.suncode.cuf.web.dto.template.WordTemplateForm;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class GenerateDocumentApp {
    private static final Logger log = LoggerFactory.getLogger(GenerateDocumentApp.class);
    @Autowired
    private WordTemplateService wordTemplateService;
    @Autowired
    private CUFCommonDocumentService documentService;
    @Autowired
    private TranslatorService translatorService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("generate-document-app")).name("application.generate-document.name")).description("application.generate-document.desc")).category(new Category[]{Categories.DOCUMENTS})).documentationLink("confluence/x/5YPK")).icon((Icon)SilkIconPack.PACKAGE)).parameter().id("format").optional().name("generate-document.format.name").description("generate-document.format.desc").defaultValue((Object)"PDF").type((Type)Types.STRING).create()).parameter().id("documentClass").optional().name("generate-document.documentClass.name").description("generate-document.documentClass.desc").type((Type)Types.STRING).create()).parameter().id("template").optional().name("generate-document.template.name").description("generate-document.template.desc").type((Type)Types.STRING).create()).parameter().id("attachToProcess").optional().name("generate-document.attach-to-process.name").description("generate-document.attach-to-process.desc").defaultValue((Object)false).type((Type)Types.BOOLEAN).create()).parameter().id("newVersion").optional().name("generate-document.new-version.name").description("generate-document.new-version.desc").defaultValue((Object)false).type((Type)Types.BOOLEAN).create()).parameter().id("documentName").optional().name("generate-document.document-name.name").description("generate-document.document-name.desc").type((Type)Types.STRING).create()).parameter().id("mappingsIds").name("generate-document.mappings-ids.name").description("generate-document.mappings-ids.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("mappingsValues").optional().name("generate-document.mappings-values.name").description("generate-document.mappings-values.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("templateSource").name("generate-document.template-source.name").description("generate-document.template-source.desc").type((Type)Types.STRING).defaultValue((Object)"PROCESS_TEMPLATE").create()).parameter().id("documentTemplateClassName").optional().name("generate-document.document-template-class-name.name").description("generate-document.document-template-class-name.desc").type((Type)Types.STRING).create();
    }

    public void execute(ApplicationContext context, @Param String format, @Param String documentClass, @Param String template, @Param Boolean attachToProcess, @Param Boolean newVersion, @Param String documentName, @Param String[] mappingsIds, @Param String[] mappingsValues, @Param String templateSource, @Param String documentTemplateClassName) throws Exception {
        try {
            log.debug("Tworz\u0119 konfiguracj\u0119 dokumentu.");
            WordTemplateForm config = new WordTemplateForm();
            config.setActivityId(context.getActivityId());
            config.setDocumentClass(documentClass);
            config.setAttachToProcess(attachToProcess.booleanValue());
            config.setProcessId(context.getProcessId());
            if (StringUtils.isEmpty((CharSequence)documentTemplateClassName)) {
                config.setTemplate(template);
            } else {
                WfFile documentFromProcess = this.getTemplateDocumentFromProcess(context.getProcessId(), documentTemplateClassName);
                config.setFileId(Long.valueOf(documentFromProcess.getId()));
            }
            config.setFormat(WordTemplateService.OutputFormat.valueOf((String)format));
            config.setNewVersion(newVersion.booleanValue());
            Map<String, Object> mappings = this.getMappings(mappingsIds, mappingsValues);
            config.setMappings(mappings);
            config.setDocumentName(documentName);
            this.wordTemplateService.generateForActivityAndAttach(config);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private WfFile getTemplateDocumentFromProcess(String processId, String documentTemplateClassName) throws IllegalArgumentException {
        Long documentClassId = this.documentService.getDocumentClassID(documentTemplateClassName);
        List<WfDocument> dokumenty = this.documentService.getDocumentsFromProcessWithDocumentClass(processId, documentClassId);
        if (dokumenty.size() == 0) {
            throw new IllegalArgumentException(this.translatorService.translate("generate-document.", "no-templates-error"));
        }
        if (dokumenty.size() > 1) {
            throw new IllegalArgumentException(this.translatorService.translate("generate-document.", "to-many-templates-error"));
        }
        return dokumenty.get(0).getFile();
    }

    private Map<String, Object> getMappings(String[] mappingsIds, String[] mappingsValues) throws IllegalArgumentException {
        HashMap<String, Object> mappings = new HashMap<String, Object>();
        if (mappingsIds != null && mappingsValues != null) {
            log.debug("Ustawiam mappingi.");
            if (mappingsIds.length != mappingsValues.length) {
                throw new IllegalArgumentException("Liczba kluczy mapping\u00f3w nie jest r\u00f3wna liczbie warto\u015bci mapping\u00f3w! ");
            }
            for (int i = 0; i < mappingsIds.length; ++i) {
                mappings.put(mappingsIds[i], mappingsValues[i]);
            }
        }
        return mappings;
    }
}

