/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db.services;

import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.Record;
import com.suncode.dbexplorer.database.query.Condition;
import com.suncode.dbexplorer.database.query.Conditions;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="recordService")
public class RecordService {
    private static final Logger log = LoggerFactory.getLogger(RecordService.class);

    public boolean updateRecord(Record record, Map<String, Object> row, DatabaseSession session) {
        this.setRecordData(record, row);
        return session.update(record);
    }

    public boolean insertRecord(String dbSchema, DatabaseSession session, String tableName, Map<String, Object> row) {
        Record record = StringUtils.hasText((String)dbSchema) ? session.createRecord(dbSchema, tableName) : session.createRecord(tableName);
        this.setRecordData(record, row);
        session.insert(record);
        return true;
    }

    public boolean deleteRecords(String dbSchema, DatabaseSession session, String tableName) {
        session.delete().from(dbSchema, tableName).execute();
        return true;
    }

    private void setRecordData(Record record, Map<String, Object> row) {
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            log.debug("Dodaje: " + entry.getKey() + "/" + entry.getValue());
            record.set(entry.getKey(), entry.getValue());
        }
    }

    public Record getRecord(String[] keyColumns, Map<String, Object> row, String dbSchema, DatabaseSession session, String tableName) {
        Condition conditions = this.generateConditions(keyColumns, row);
        return StringUtils.hasText((String)dbSchema) ? session.select().from(dbSchema, tableName).where(conditions).uniqueRecord() : session.select().from(tableName).where(conditions).uniqueRecord();
    }

    public List<Record> getRecords(String[] keyColumns, Map<String, Object> row, String dbSchema, DatabaseSession session, String tableName) {
        Condition conditions = this.generateConditions(keyColumns, row);
        return StringUtils.hasText((String)dbSchema) ? session.select().from(dbSchema, tableName).where(conditions).list() : session.select().from(tableName).where(conditions).list();
    }

    private Condition generateConditions(String[] keyColumns, Map<String, Object> row) {
        Condition[] conditions = new Condition[keyColumns.length];
        for (int i = 0; i < keyColumns.length; ++i) {
            conditions[i] = Conditions.eq((String)keyColumns[i], (Object)row.get(keyColumns[i]));
        }
        return Conditions.and((Condition[])conditions);
    }
}

