/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.db.datachoosers.utils;

import com.suncode.cuf.common.db.datachoosers.utils.ConditionOperator;
import com.suncode.dbexplorer.database.query.Condition;
import com.suncode.dbexplorer.database.query.Conditions;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.variable.Variable;
import org.springframework.util.StringUtils;

public class ConditionGenerator {
    private String[] andConstraints;
    private String[] orConstraints;
    private ActivityContextMap context;

    public ConditionGenerator(String[] andConstraints, String[] orConstraints, ActivityContextMap contextMap) {
        this.andConstraints = andConstraints;
        this.orConstraints = orConstraints;
        this.context = contextMap;
    }

    public Condition generateConditions() {
        Condition finalConditions = null;
        Condition andConditions = this.generateAndOrOrConditions(true, this.andConstraints);
        Condition orConditions = this.generateAndOrOrConditions(false, this.orConstraints);
        finalConditions = andConditions != null && orConditions != null ? Conditions.and((Condition[])new Condition[]{andConditions, orConditions}) : (andConditions != null ? andConditions : orConditions);
        return finalConditions;
    }

    private Condition generateAndOrOrConditions(boolean and, String[] constraints) {
        Condition conditions = null;
        Condition[] conditionsArray = null;
        if (constraints != null && constraints.length > 0 && StringUtils.hasText((String)constraints[0])) {
            conditionsArray = new Condition[constraints.length];
            for (int i = 0; i < constraints.length; ++i) {
                conditionsArray[i] = this.generateCondition(constraints[i]);
            }
            conditions = and ? Conditions.and((Condition[])conditionsArray) : Conditions.or((Condition[])conditionsArray);
        }
        return conditions;
    }

    private Condition generateCondition(String constraint) {
        String[] constraintParts = constraint.split(" ");
        String dbColumn = constraintParts[0];
        ConditionOperator operator = ConditionOperator.getOperator(constraintParts[1]);
        Object value = this.getValue(constraintParts[2]);
        Condition condition = this.getFinalCondition(dbColumn, operator, value);
        return condition;
    }

    private Condition getFinalCondition(String dbColumn, ConditionOperator operator, Object value) {
        Condition condition = null;
        if (operator == ConditionOperator.EQ) {
            condition = Conditions.eq((String)dbColumn, (Object)value);
        } else if (operator == ConditionOperator.NOTEQ) {
            condition = Conditions.not((Condition)Conditions.eq((String)dbColumn, (Object)value));
        } else if (operator == ConditionOperator.GT) {
            condition = Conditions.gt((String)dbColumn, (Object)value);
        } else if (operator == ConditionOperator.LT) {
            condition = Conditions.lt((String)dbColumn, (Object)value);
        } else if (operator == ConditionOperator.GE) {
            condition = Conditions.ge((String)dbColumn, (Object)value);
        } else if (operator == ConditionOperator.LE) {
            condition = Conditions.le((String)dbColumn, (Object)value);
        }
        return condition;
    }

    private Object getValue(String part) {
        Object value = "";
        if (part.contains("@")) {
            Variable variable = this.context.getVariable(part.substring(1, part.length()));
            value = variable.getValue();
        } else {
            value = part;
        }
        return value;
    }
}

