/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.datasource.datachoosers;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.utils.DataConverter;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.util.Assert;

@DataChooser
@ComponentsFormScript(value="scripts/dynamic-pwe/datasource-datachooser.js")
public class DataSourceDataChooser {
    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("datasource-datachooser")).name("datasource-datachooser")).description("datasource-datachooser.desc")).enableCustomMappings().category(new Category[]{Categories.DATASOURCES})).icon((Icon)SilkIconPack.SERVER_DATABASE)).parameter().id("datasource").name("datasource.param.datasource.name").description("datasource.param.datasource.desc").type((Type)Types.STRING).create()).parameter().id("datasources").name("datasource.param.datasources.name").description("datasource.param.datasources.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("datasourceInputParametersId").name("datasource.datasourceInputParametersId.name").description("datasource.datasourceInputParametersId.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("datasourceInputParametersValue").name("datasource.datasourceInputParametersValue.name").description("datasource.datasourceInputParametersValue.desc").type((Type)Types.STRING_ARRAY).create();
    }

    public void data(ComponentQueryData queryData, DataChooserResult result, @Param DataSourceInstance datasource, Parameters parameters) {
        Assert.notNull((Object)datasource, (String)"Chosen datasource does not exist!");
        String[] datasourceInputParametersId = (String[])parameters.get("datasourceInputParametersId", String[].class);
        Map<String, String> datasourceInputParameters = IntStream.range(0, datasourceInputParametersId.length).boxed().filter(i -> datasource.getInputParameters().stream().anyMatch(datasourceInputParameter -> datasourceInputParameter.getId().equals(datasourceInputParametersId[i]))).collect(Collectors.toMap(i -> ((String[])parameters.get("datasourceInputParametersId", String[].class))[i], i -> this.resolveParameterValue(DataConverter.argumentToStringArray(parameters.getRaw("datasourceInputParametersValue"))[i], queryData)));
        CountedResult countedData = datasource.execute(datasourceInputParameters, queryData.getFilters(), queryData.getPagination());
        result.setData(countedData.getData());
        result.setTotal(countedData.getTotal());
    }

    private String resolveParameterValue(String parameter, ComponentQueryData queryData) {
        if (parameter.equals("DCKEY")) {
            return queryData.getQuery();
        }
        if (parameter.startsWith("DCKEY_")) {
            String idMapping = parameter.substring(6);
            String value = (String)queryData.getFilters().get(idMapping);
            return value == null ? "" : value;
        }
        return parameter;
    }
}

