PW.FormActions.create('expand-collapse-table', {
    
    variableSetInit : function (table){
        this.table = table;
    },
    
    buttonInit : function(button) {
        this.table = VariableSetService.getVariableSet(this.get("tableId"));
    },
    
    defaultActions: {
        button: function(button){
            this.expandCollapseTable(true);
        }
    },
    
    enable : function(){
        if ( this.target.type != "BUTTON" ){
            this.expandCollapseTable(true);
        }
    },
    
    disable : function(){
        if ( this.target.type != "BUTTON" ){
            this.expandCollapseTable(false);
        }
    },
    
    expandCollapseTable : function(enable){
        if (this.get("actionType") == "COLLAPSE" ){
            if (enable){
                this.table.collapse();
            } else{
                this.table.expand();
            }
        }
        else if (this.get("actionType") == "EXPAND"){
            if (enable){
                this.table.expand();
            } else{
                this.table.collapse();
            }
        }
        else{
            Logger.error("Unknown action type in expand-collapse-table action!");
        }
    }
});