/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.utils.handlers;

import com.suncode.cuf.common.utils.handlers.Handler;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StandardHandler
implements Handler {
    private static final Logger log = LoggerFactory.getLogger(StandardHandler.class);
    private String processId;
    private String activityId;
    private String message;

    @Autowired
    public StandardHandler(String processId, String activityId, String message) {
        processId = this.checkBlank("ProcessId", processId);
        activityId = this.checkBlank("ActivityId", activityId);
        message = this.checkBlank("Comment message", message);
        this.processId = processId;
        this.activityId = activityId;
        this.message = message;
    }

    @Autowired
    public StandardHandler(String processId, String activityId, Exception e) {
        processId = this.checkBlank("ProcessId", processId);
        this.processId = processId = this.checkBlank("ActivityId", activityId);
        this.activityId = activityId;
        this.message = e.getMessage();
    }

    @Override
    public void handle() {
        log.error(this.buildLogMsg());
    }

    private String checkBlank(String name, String value) {
        if (StringUtils.isBlank((String)value)) {
            log.debug(name + " is blank!");
            return "Unknown";
        }
        return value;
    }

    private String buildLogMsg() {
        StringBuilder sb = new StringBuilder();
        sb.append("ProcessId: ").append(this.processId).append(" ActivityId: ").append(this.activityId).append(" Msg: ").append(this.message);
        return sb.toString();
    }
}

