/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.utils;

import com.suncode.pwfl.database.sequence.SequenceService;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SequenceGenerator {
    private static final Logger log = LoggerFactory.getLogger(SequenceGenerator.class);
    private SequenceService sequenceService;
    private String format;
    private String seqName;
    private static final String YEAR_REGEX = "\\[R(\\d)\\]";
    private static final String NUMBER_REGEX = "\\[N(\\d)\\]";

    public SequenceGenerator(String format, String seqName, SequenceService seqService) {
        this.format = format;
        this.seqName = seqName;
        this.sequenceService = seqService;
    }

    public String generate() {
        int yearLength = this.getYearLength(this.format, YEAR_REGEX);
        String formattedYear = this.formatYear(this.getCurrentYear(), yearLength);
        int numberLength = this.getNumberLength(this.format, NUMBER_REGEX);
        String sequenceNumber = this.getSequenceNumber(this.seqName, numberLength);
        String finalNumber = this.format.replaceFirst(NUMBER_REGEX, sequenceNumber).replaceFirst(YEAR_REGEX, formattedYear);
        log.debug("*** Generated formatted number: {}", (Object)finalNumber);
        return finalNumber;
    }

    private int getNumberLength(String format, String regex) {
        int numberLength = this.getDigitsOrYear(format, regex);
        Assert.isTrue((numberLength > 0 ? 1 : 0) != 0, (String)"[Assertion failed] - this expression must be true");
        return numberLength;
    }

    private int getYearLength(String format, String regex) {
        int yearLength = this.getDigitsOrYear(format, regex);
        return yearLength;
    }

    private int getDigitsOrYear(String format, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(format);
        String numberGroup = "0";
        while (matcher.find()) {
            numberGroup = matcher.group(1);
        }
        return Integer.parseInt(numberGroup);
    }

    private String formatYear(String year, int yearLength) {
        if (yearLength > 2) {
            return year;
        }
        return year.substring(year.length() - 2, year.length());
    }

    String getCurrentYear() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        String sYear = String.valueOf(year);
        return sYear;
    }

    private String getSequenceNumber(String sequenceName, int noOfDigits) {
        Long sequenceNumber = 0L;
        if (this.sequenceService.sequenceExist(sequenceName)) {
            sequenceNumber = this.sequenceService.getNextSequenceValue(sequenceName);
        } else {
            this.sequenceService.createSequence(sequenceName, 1, 1);
            sequenceNumber = this.sequenceService.getNextSequenceValue(sequenceName);
        }
        return this.addZeroesToSequenceNumber(String.valueOf(sequenceNumber), noOfDigits);
    }

    private String addZeroesToSequenceNumber(String sequenceNumber, int noOfDigits) {
        String sequence = "";
        for (int numberOfZeroes = noOfDigits - sequenceNumber.length(); numberOfZeroes > 0; --numberOfZeroes) {
            sequence = sequence + "0";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sequence).append(sequenceNumber);
        return sb.toString();
    }
}

