/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.tablestore.functions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.suncode.cuf.common.tablestore.TableStore;
import com.suncode.cuf.common.tablestore.functions.AggregateFunctionsUtil;
import com.suncode.cuf.common.tablestore.functions.Column;
import com.suncode.cuf.common.tablestore.functions.FunctionType;
import com.suncode.cuf.common.tablestore.functions.GroupedRow;
import com.suncode.cuf.common.tablestore.functions.Row;
import com.suncode.pwfl.core.function.annotation.Function;
import com.suncode.pwfl.core.function.annotation.Functions;
import com.suncode.pwfl.core.function.annotation.FunctionsScript;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@Functions
@FunctionsScript(value="/functions/tablestore-groupby-function.js")
public class TableStoreGroupByFunctions {
    private static final Gson gson = new GsonBuilder().serializeNulls().create();

    @Function
    @Deprecated
    public String groupBy(String[] aggregateFunctions, Variable[] rawColumns, String concatSeparator, String decimalPlaces, Variable[] groupByColumns) {
        List<Row> aggregatedRows = this.getRows(aggregateFunctions, rawColumns, concatSeparator, decimalPlaces, groupByColumns);
        TableStore tableStore = this.createTableStore(aggregatedRows, rawColumns);
        return gson.toJson((Object)tableStore);
    }

    @Function(value="TableStore.groupBy")
    public String groupBy(String[] aggregateFunctions, Variable[] rawColumns, String[] fieldId, String concatSeparator, String decimalPlaces, Variable[] groupByColumns) {
        List<Row> aggregatedRows = this.getRows(aggregateFunctions, rawColumns, concatSeparator, decimalPlaces, groupByColumns);
        Map<String, String> keyMapping = this.buildTableStoreKeyMapping(rawColumns, fieldId);
        TableStore tableStore = this.createTableStore(aggregatedRows, rawColumns, keyMapping);
        return gson.toJson((Object)tableStore);
    }

    private List<Row> getRows(String[] aggregateFunctions, Variable[] rawColumns, String concatSeparator, String decimalPlaces, Variable[] groupByColumns) {
        Map<String, FunctionType> columnFunctionSet = this.columnAggregateFunction(rawColumns, aggregateFunctions);
        List<Row> rows = this.toRows((Variable[])ArrayUtils.addAll((Object[])rawColumns, (Object[])groupByColumns));
        List<String> groupingColumnIds = Stream.of(groupByColumns).map(Variable::getId).collect(Collectors.toList());
        List<String> columnIds = Stream.of(rawColumns).map(Variable::getId).collect(Collectors.toList());
        List<GroupedRow> groupedRows = this.groupRows(rows, groupingColumnIds);
        return this.aggregateGroupedRows(columnIds, groupedRows, concatSeparator, decimalPlaces, columnFunctionSet);
    }

    private Map<String, String> buildTableStoreKeyMapping(Variable[] groupByColumns, String[] tableStoreKeys) {
        HashMap<String, String> tableStoreKeyMapping = new HashMap<String, String>();
        for (int index = 0; index < groupByColumns.length; ++index) {
            Variable variable = groupByColumns[index];
            if (variable == null) continue;
            String newFieldId = variable.getId();
            if (tableStoreKeys.length > index && StringUtils.isNotBlank((CharSequence)tableStoreKeys[index])) {
                newFieldId = tableStoreKeys[index];
            }
            tableStoreKeyMapping.put(variable.getId(), newFieldId);
        }
        return tableStoreKeyMapping;
    }

    private Map<String, FunctionType> columnAggregateFunction(Variable[] columns, String[] aggregateFunctions) {
        HashMap<String, FunctionType> result = new HashMap<String, FunctionType>();
        for (int i = 0; i < columns.length; ++i) {
            result.put(columns[i].getId(), FunctionType.valueOf(aggregateFunctions[i]));
        }
        return result;
    }

    private List<Row> toRows(Variable[] rawColumns) {
        Variable column = rawColumns[0];
        Object[] valuesInColumn = (Object[])column.getValue();
        int rowsCount = valuesInColumn.length;
        return IntStream.range(0, rowsCount).mapToObj(i -> {
            List<Column> columns = Arrays.stream(rawColumns).map(variable -> new Column(variable.getId(), ((Object[])variable.getValue())[i])).collect(Collectors.toList());
            return new Row(columns);
        }).collect(Collectors.toList());
    }

    private List<GroupedRow> groupRows(List<Row> rows, List<String> groupingColumnIds) {
        LinkedList<GroupedRow> groupedRows = new LinkedList<GroupedRow>();
        rows.forEach(row -> {
            int hash = groupingColumnIds.stream().map(row::getValueForColumn).collect(Collectors.toList()).hashCode();
            Optional<GroupedRow> optionalGroupedRow = groupedRows.stream().filter(matchingRow -> matchingRow.getHash() == hash).findFirst();
            if (optionalGroupedRow.isPresent()) {
                List<List<Column>> columns = optionalGroupedRow.get().getListOfColumns();
                columns.add(row.getColumns());
            } else {
                LinkedList<List<Column>> columns = new LinkedList<List<Column>>();
                columns.add(row.getColumns());
                groupedRows.add(new GroupedRow(hash, columns));
            }
        });
        return groupedRows;
    }

    private List<Row> aggregateGroupedRows(List<String> columnIds, List<GroupedRow> groupedRows, String concatSeparator, String decimalPlaces, Map<String, FunctionType> columnFunctionMap) {
        return groupedRows.stream().map(row -> {
            List<List<Column>> listOfColumns = row.getListOfColumns();
            return columnIds.stream().map(columnId -> {
                List<Object> valuesToAggregate = listOfColumns.stream().map(columns -> columns.stream().filter(column -> column.getColumnId().equals(columnId)).findFirst().orElseThrow(RuntimeException::new)).map(Column::getValue).collect(Collectors.toList());
                FunctionType aggregateFunctions = (FunctionType)((Object)((Object)((Object)columnFunctionMap.get(columnId))));
                return new Column((String)columnId, this.callAggregateFun(valuesToAggregate, concatSeparator, decimalPlaces, aggregateFunctions));
            }).collect(Collectors.toList());
        }).map(Row::new).collect(Collectors.toList());
    }

    private Object callAggregateFun(List<Object> valuesToAggregate, String concatSeparator, String decimalPlaces, FunctionType functionType) {
        switch (functionType) {
            case CONCAT: {
                return AggregateFunctionsUtil.concat(valuesToAggregate, concatSeparator);
            }
            case SUM: {
                return AggregateFunctionsUtil.sum(valuesToAggregate);
            }
            case MIN: {
                return AggregateFunctionsUtil.min(valuesToAggregate);
            }
            case MAX: {
                return AggregateFunctionsUtil.max(valuesToAggregate);
            }
            case AVG: {
                return AggregateFunctionsUtil.avg(valuesToAggregate, decimalPlaces);
            }
            case COUNT: {
                return AggregateFunctionsUtil.count(valuesToAggregate);
            }
            case GROUPINGVAL: {
                return valuesToAggregate.get(0);
            }
        }
        throw new IllegalArgumentException("Aggregate function not found");
    }

    private TableStore createTableStore(List<Row> aggregatedRows, Variable[] rawColumns) {
        TableStore tableStore = new TableStore(rawColumns);
        tableStore.getData().clear();
        aggregatedRows.forEach(row -> tableStore.addRecord(row.getColumnsIds(), row.getColumnsValues()));
        return tableStore;
    }

    private TableStore createTableStore(List<Row> aggregatedRows, Variable[] rawColumns, Map<String, String> keyMapping) {
        TableStore tableStore = new TableStore(rawColumns, keyMapping);
        tableStore.getData().clear();
        aggregatedRows.forEach(row -> {
            String[] ids = (String[])Arrays.stream(row.getColumnsIds()).map(id -> (String)keyMapping.get(id)).toArray(String[]::new);
            tableStore.addRecord(ids, row.getColumnsValues());
        });
        return tableStore;
    }
}

