/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.table.duals;

import com.suncode.cuf.common.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.data.TableStore;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.variable.Variable;
import com.suncode.pwfl.xpdl.table.Table;
import com.suncode.pwfl.xpdl.table.XpdlTableService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
public class ConditionalRowDeleteDual {
    private static final Logger log = LoggerFactory.getLogger(ConditionalRowDeleteDual.class);
    private static final String NULL_STRING = "null";
    @Autowired
    private XpdlTableService xpdlTableService;
    @Autowired
    private ProcessService processService;

    @Define
    public void action(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("conditional-row-delete-dual")).name("dual.conditional-row-delete-dual.name")).description("dual.conditional-row-delete-dual.desc")).icon((Icon)DivanteIcon.TABLE_ROW_DELETE)).category(new Category[]{Categories.TABLE})).documentationLink("confluence/x/xQWCAQ")).contextVariable().id("currentRow").name("dual.conditional-row-delete-dual.param.currentRow.name").description("dual.conditional-row-delete-dual.param.currentRow.desc").type((Type)Types.INTEGER).create().parameter().id("tableId").name("dual.conditional-row-delete-dual.param.tableId.name").description("dual.conditional-row-delete-dual.param.tableId.desc").type((Type)Types.STRING).create()).parameter().id("condition").name("dual.conditional-row-delete-dual.param.condition.name").description("dual.conditional-row-delete-dual.param.condition.desc").type((Type)Types.FUNCTION).create();
    }

    public void execute(@Param String tableId, @Param FunctionCall condition, ContextVariables contextVariables, ActivityContextMap context) {
        this.deleteRowsOnCondition(tableId, condition, contextVariables, context);
    }

    public void set(@Param String tableId, @Param FunctionCall condition, ContextVariables contextVariables, ActivityContextMap activityContextMap) {
        this.deleteRowsOnCondition(tableId, condition, contextVariables, activityContextMap);
    }

    private void deleteRowsOnCondition(String tableId, FunctionCall condition, ContextVariables contextVariables, ActivityContextMap activityContextMap) {
        Process process = this.processService.getProcess(activityContextMap.getProcessId(), new String[]{"processDefinition"});
        String processDefId = process.getProcessDefinition().getProcessDefinitionId();
        Table table = this.xpdlTableService.getGlobalTable(tableId, processDefId);
        TableStore tableStore = new TableStore(table, activityContextMap.getVariables());
        List data = tableStore.getData();
        List filteredRecords = IntStream.range(0, data.size()).filter(index -> {
            contextVariables.set("currentRow", (Object)index);
            return Boolean.FALSE.equals(condition.call());
        }).mapToObj(data::get).collect(Collectors.toList());
        tableStore.setData(filteredRecords);
        this.setProcessVariables(tableStore, activityContextMap);
    }

    private void setProcessVariables(TableStore tableStore, ActivityContextMap activityContextMap) {
        Map<Object, String> tableStoreVariablesMap = tableStore.getData().isEmpty() ? tableStore.getVariableType().keySet().stream().collect(Collectors.toMap(Function.identity(), varId -> "")) : tableStore.getData().stream().flatMap(rec -> rec.getFields().entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(entry -> String.valueOf(entry.getValue()), Collectors.joining(";"))));
        for (Map.Entry tableStoreVariableEntry : tableStoreVariablesMap.entrySet()) {
            Variable variable = activityContextMap.getVariable((String)tableStoreVariableEntry.getKey());
            Object[] valuesToSet = tableStoreVariableEntry.getValue().split(";", -1);
            if (!variable.getType().toString().equals("string[]")) {
                valuesToSet = Arrays.stream(valuesToSet).map(value -> value.equals(NULL_STRING) ? null : value).toArray();
            }
            variable.setValue(variable.getType().read((Object)valuesToSet));
        }
    }
}

