/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.storagedata.functions;

import com.suncode.cuf.common.storagedata.StorageData;
import com.suncode.cuf.common.storagedata.StorageDataService;
import com.suncode.cuf.common.storagedata.utils.StorageDataUtils;
import com.suncode.pwfl.core.function.annotation.Function;
import com.suncode.pwfl.core.function.annotation.Functions;
import com.suncode.pwfl.core.function.annotation.FunctionsScript;
import java.util.ArrayList;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Functions
@FunctionsScript(value="/functions/storagedata-functions.js")
public class StorageDataFunctions {
    private static final Logger log = LoggerFactory.getLogger(StorageDataFunctions.class);
    private final StorageDataService storageDataService;

    @Autowired
    public StorageDataFunctions(StorageDataService storageDataService) {
        this.storageDataService = storageDataService;
    }

    @Function(value="StorageData.getString")
    public String getStringFromStorageData(String paramName) {
        String storageDataValue = this.storageDataService.getFormalParameterValueFromProcess("StorageData");
        StorageData storageData = new StorageData(storageDataValue);
        if (!storageData.parameterNameExists(paramName)) {
            log.error("Parameter with name: " + paramName + " doesn't exist in StorageData");
            return "";
        }
        return (String)storageData.getData().get(paramName);
    }

    @Function(value="StorageData.getInteger")
    public Integer getIntegerFromStorageData(String paramName) {
        String storageDataValue = this.storageDataService.getFormalParameterValueFromProcess("StorageData");
        StorageData storageData = new StorageData(storageDataValue);
        if (!storageData.parameterNameExists(paramName)) {
            log.error("Parameter with name '" + paramName + "' doesn't exist in StorageData");
            return 0;
        }
        if (!StorageDataUtils.isParameterIntegerValue(storageData.getData().get(paramName))) {
            throw new IllegalArgumentException("Given paramName '" + paramName + "' doesn't refer to Integer value");
        }
        return (Integer)storageData.getData().get(paramName);
    }

    @Function(value="StorageData.getFloat")
    public Double getDoubleFromStorageData(String paramName) {
        String storageDataValue = this.storageDataService.getFormalParameterValueFromProcess("StorageData");
        StorageData storageData = new StorageData(storageDataValue);
        if (!storageData.parameterNameExists(paramName)) {
            log.error("Parameter with name '" + paramName + "' doesn't exist in StorageData");
            return 0.0;
        }
        if (!StorageDataUtils.isParameterDoubleValue(storageData.getData().get(paramName))) {
            throw new IllegalArgumentException("Given paramName '" + paramName + "' doesn't refer to Float value");
        }
        return (Double)storageData.getData().get(paramName);
    }

    @Function(value="StorageData.getBoolean")
    public Boolean getBooleanFromStorageData(String paramName) {
        String storageDataValue = this.storageDataService.getFormalParameterValueFromProcess("StorageData");
        StorageData storageData = new StorageData(storageDataValue);
        if (!storageData.parameterNameExists(paramName)) {
            log.error("Parameter with name '" + paramName + "' doesn't exist in StorageData");
            return null;
        }
        if (!StorageDataUtils.isParameterBooleanValue(storageData.getData().get(paramName))) {
            throw new IllegalArgumentException("Given paramName '" + paramName + "' doesn't refer to Boolean value");
        }
        return (Boolean)storageData.getData().get(paramName);
    }

    @Function(value="StorageData.getDate")
    public LocalDate getDateFromStorageData(String paramName) {
        String storageDataValue = this.storageDataService.getFormalParameterValueFromProcess("StorageData");
        StorageData storageData = new StorageData(storageDataValue);
        if (!storageData.parameterNameExists(paramName) || storageData.getData().get(paramName) == null) {
            log.error("Parameter with name '" + paramName + "' doesn't exist in StorageData or is null");
            return null;
        }
        String storageDataDateValue = (String)storageData.getData().get(paramName);
        if (!StorageDataUtils.isParameterDateValue(storageDataDateValue)) {
            throw new IllegalArgumentException("Given paramName '" + paramName + "' doesn't refer to LocalDate value");
        }
        return LocalDate.parse((String)storageDataDateValue);
    }

    @Function(value="StorageData.getDateTime")
    public LocalDateTime getDateTimeFromStorageData(String paramName) {
        String storageDataValue = this.storageDataService.getFormalParameterValueFromProcess("StorageData");
        StorageData storageData = new StorageData(storageDataValue);
        if (!storageData.parameterNameExists(paramName) || storageData.getData().get(paramName) == null) {
            log.error("Parameter with name '" + paramName + "' doesn't exist in StorageData or is null");
            return null;
        }
        String storageDataDateTimeValue = (String)storageData.getData().get(paramName);
        if (!StorageDataUtils.isParameterDateTimeValue(storageDataDateTimeValue)) {
            throw new IllegalArgumentException("Given paramName '" + paramName + "' doesn't refer to LocalDateTime value");
        }
        return LocalDateTime.parse((String)storageDataDateTimeValue, (DateTimeFormatter)StorageDataUtils.DATE_TIME_FORMATTER);
    }

    @Function(value="StorageData.getStringArray")
    public String[] getStringArrayFromStorageData(String paramName) {
        String storageDataValue = this.storageDataService.getFormalParameterValueFromProcess("StorageData");
        StorageData storageData = new StorageData(storageDataValue);
        if (!storageData.parameterNameExists(paramName)) {
            log.error("Parameter with name: " + paramName + " doesn't exist in StorageData");
            return new String[0];
        }
        return ((ArrayList)storageData.getData().get(paramName)).toArray(new String[0]);
    }

    @Function(value="StorageData.getIntegerArray")
    public Integer[] getIntegerArrayFromStorageData(String paramName) {
        String storageDataValue = this.storageDataService.getFormalParameterValueFromProcess("StorageData");
        StorageData storageData = new StorageData(storageDataValue);
        if (!storageData.parameterNameExists(paramName)) {
            log.error("Parameter with name '" + paramName + "' doesn't exist in StorageData");
            return new Integer[0];
        }
        if (!StorageDataUtils.isParameterIntegerArrayValue(storageData.getData().get(paramName))) {
            throw new IllegalArgumentException("Given paramName '" + paramName + "' doesn't refer to integer[] value");
        }
        return ((ArrayList)storageData.getData().get(paramName)).toArray(new Integer[0]);
    }

    @Function(value="StorageData.getFloatArray")
    public Double[] getDoubleArrayFromStorageData(String paramName) {
        String storageDataValue = this.storageDataService.getFormalParameterValueFromProcess("StorageData");
        StorageData storageData = new StorageData(storageDataValue);
        if (!storageData.parameterNameExists(paramName)) {
            log.error("Parameter with name '" + paramName + "' doesn't exist in StorageData");
            return new Double[0];
        }
        if (!StorageDataUtils.isParameterDoubleArrayValue(storageData.getData().get(paramName))) {
            throw new IllegalArgumentException("Given paramName '" + paramName + "' doesn't refer to Float[] value");
        }
        return ((ArrayList)storageData.getData().get(paramName)).toArray(new Double[0]);
    }

    @Function(value="StorageData.getBooleanArray")
    public Boolean[] getBooleanArrayFromStorageData(String paramName) {
        String storageDataValue = this.storageDataService.getFormalParameterValueFromProcess("StorageData");
        StorageData storageData = new StorageData(storageDataValue);
        if (!storageData.parameterNameExists(paramName)) {
            log.error("Parameter with name '" + paramName + "' doesn't exist in StorageData");
            return new Boolean[0];
        }
        if (!StorageDataUtils.isParameterBooleanArrayValue(storageData.getData().get(paramName))) {
            throw new IllegalArgumentException("Given paramName '" + paramName + "' doesn't refer to Boolean[] value");
        }
        return ((ArrayList)storageData.getData().get(paramName)).toArray(new Boolean[0]);
    }

    @Function(value="StorageData.getDateArray")
    public LocalDate[] getDateArrayFromStorageData(String paramName) {
        String storageDataValue = this.storageDataService.getFormalParameterValueFromProcess("StorageData");
        StorageData storageData = new StorageData(storageDataValue);
        if (!storageData.parameterNameExists(paramName)) {
            log.error("Parameter with name '" + paramName + "' doesn't exist in StorageData");
            return new LocalDate[0];
        }
        if (!StorageDataUtils.isParameterDateArrayValue(storageData.getData().get(paramName))) {
            throw new IllegalArgumentException("Given paramName '" + paramName + "' doesn't refer to LocalDate[] type value in format yyyy-MM-dd saved as String[] in StorageData");
        }
        String[] datesAsText = ((ArrayList)storageData.getData().get(paramName)).toArray(new String[0]);
        return StorageDataUtils.convertStringArrayToLocalDateArray(datesAsText);
    }

    @Function(value="StorageData.getDateTimeArray")
    public LocalDateTime[] getDateTimeArrayFromStorageData(String paramName) {
        String storageDataValue = this.storageDataService.getFormalParameterValueFromProcess("StorageData");
        StorageData storageData = new StorageData(storageDataValue);
        if (!storageData.parameterNameExists(paramName)) {
            log.error("Parameter with name '" + paramName + "' doesn't exist in StorageData");
            return new LocalDateTime[0];
        }
        if (!StorageDataUtils.isParameterDateTimeTableValue(storageData.getData().get(paramName))) {
            throw new IllegalArgumentException("Given paramName '" + paramName + "' doesn't refer to LocalDateTime[] type value in yyyy-MM-dd HH:mm:ss format saved as String[] in StorageData");
        }
        String[] datesTimeAsText = ((ArrayList)storageData.getData().get(paramName)).toArray(new String[0]);
        return StorageDataUtils.convertStringArrayToLocalDateTimeArray(datesTimeAsText);
    }

    @Function(value="StorageData.exist")
    public Boolean checkIfParameterExists(String paramName) {
        String storageDataValue = this.storageDataService.getFormalParameterValueFromProcess("StorageData");
        StorageData storageData = new StorageData(storageDataValue);
        return storageData.parameterNameExists(paramName);
    }
}

