/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.general.functions;

import com.suncode.pwfl.core.function.annotation.Function;
import com.suncode.pwfl.core.function.annotation.Functions;
import com.suncode.pwfl.core.function.annotation.FunctionsScript;

@Functions
@FunctionsScript(value="/functions/format-functions.js")
public class FormatFunctions {
    static final char MASK_CHAR = '#';
    static final char SPACE_CHAR = '-';

    @Function
    public String ibanFormat(String input) {
        if (input.isEmpty()) {
            return input;
        }
        if (Character.isLetter(input.charAt(0)) && Character.isLetter(input.charAt(1))) {
            return this.maskFormat("####-####-####-####-####-####-####-####-####-####", input);
        }
        return this.maskFormat("##-####-####-####-####-####-####-####-####-####", input);
    }

    private String maskFormat(String mask, String input) {
        if (mask.isEmpty() || input.isEmpty() || input.length() > mask.replace("-", "").length()) {
            return input;
        }
        StringBuilder sb = new StringBuilder();
        int inputCharPosition = 0;
        for (int i = 0; i < mask.length() && input.length() > inputCharPosition; ++i) {
            if (mask.charAt(i) == '#') {
                sb.append(input.charAt(inputCharPosition++));
                continue;
            }
            if (mask.charAt(i) != '-') continue;
            sb.append(' ');
        }
        return sb.toString();
    }
}

