/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.validators;

import com.suncode.cuf.archive.verification.ConditionType;
import com.suncode.cuf.archive.verification.DocumentVerifier;
import com.suncode.cuf.archive.verification.VerificationMode;
import com.suncode.cuf.archive.verification.internal.condition.EQCondition;
import com.suncode.cuf.archive.verification.internal.condition.GECondition;
import com.suncode.cuf.archive.verification.internal.condition.GTCondition;
import com.suncode.cuf.archive.verification.internal.condition.LECondition;
import com.suncode.cuf.archive.verification.internal.condition.LTCondition;
import com.suncode.cuf.archive.verification.internal.condition.NOTEQCondition;
import com.suncode.cuf.archive.verification.internal.mode.ActivityVerificationMode;
import com.suncode.cuf.archive.verification.internal.mode.ProcessVerificationMode;
import com.suncode.cuf.archive.verification.internal.mode.StageVerificationMode;
import com.suncode.cuf.archive.verification.model.VerificationCondition;
import com.suncode.cuf.archive.verification.model.VerificationDefinition;
import com.suncode.cuf.archive.verification.model.VerificationResult;
import com.suncode.cuf.common.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.util.annotation.Deprecated;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@Deprecated(replacement="verify-documents")
@Validator
public class ValidateDocuments {
    @Autowired
    private DocumentVerifier verifier;

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("validate-documents")).name("validator.validate-document.name")).description("validator.validate-document.desc")).category(new Category[]{Categories.DOCUMENTS})).documentationLink("confluence/x/VoTK")).icon((Icon)SilkIconPack.ACCEPT)).parameter().id("verificationMode").name("validator.validate-document.verify-mode.name").description("validator.validate-document.verify-mode.desc").type((Type)Types.STRING).create()).parameter().id("showMessage").name("validator.validate-document.show-msg.name").description("validator.validate-document.show-msg.desc").type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("conditions").name("validator.validate-document.conditions.name").description("validator.validate-document.conditions.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("confirmation").name("validator.confirm_param.name_default").description("validator.confirm_param.desc_default").type((Type)Types.BOOLEAN).create();
    }

    public void validate(@Param String verificationMode, @Param Boolean showMessage, @Param String[] conditions, @Param Boolean confirmation, ValidationContext validationContext, ValidationErrors errors, Translator translator) {
        VerificationDefinition verificationDefinition = new VerificationDefinition();
        verificationDefinition.setProcessId(validationContext.getProcessId());
        verificationDefinition.setActivityId(validationContext.getActivityId());
        verificationDefinition.setMode(this.establishMode(verificationMode, errors));
        List<VerificationCondition> verificationConditions = this.formVerificationConditions(conditions, errors);
        verificationDefinition.setConditions(verificationConditions);
        VerificationResult result = this.verifier.verifyDocuments(verificationDefinition);
        String msg = result.getMessage();
        if (StringUtils.hasText((String)msg)) {
            if (confirmation.booleanValue()) {
                errors.addConfirmation(msg, translator.getMessage("validator.title_default"));
            } else {
                errors.add(msg);
            }
        }
    }

    private VerificationMode establishMode(String verificationMode, ValidationErrors errors) {
        ProcessVerificationMode mode;
        if (verificationMode.equalsIgnoreCase("process")) {
            mode = new ProcessVerificationMode();
        } else if (verificationMode.equalsIgnoreCase("activity")) {
            mode = new ActivityVerificationMode();
        } else if (verificationMode.equalsIgnoreCase("stage")) {
            mode = new StageVerificationMode();
        } else {
            errors.add("B\u0142\u0119dny tryb weryfikacji! Dozwolone tryby, to: process, activity i stage.");
            throw new IllegalArgumentException("B\u0142\u0119dny tryb weryfikacji! Dozwolone tryby, to: process, activity i stage.");
        }
        return mode;
    }

    private List<VerificationCondition> formVerificationConditions(String[] conditions, ValidationErrors errors) {
        ArrayList<VerificationCondition> verificationConditions = new ArrayList<VerificationCondition>();
        VerificationCondition verificationCondition = new VerificationCondition();
        for (String condition : conditions) {
            String[] splitCondition = condition.split(":");
            this.setAttribute(splitCondition, verificationCondition, errors);
        }
        verificationConditions.add(verificationCondition);
        return verificationConditions;
    }

    private void setAttribute(String[] splitCondition, VerificationCondition verificationCondition, ValidationErrors errors) {
        if (splitCondition[0].equalsIgnoreCase("documentClassName")) {
            verificationCondition.setDocumentClassName(splitCondition[1]);
        } else if (splitCondition[0].equalsIgnoreCase("documentClassId")) {
            verificationCondition.setDocumentClassId(Long.valueOf(Long.parseLong(splitCondition[1])));
        } else if (splitCondition[0].equalsIgnoreCase("documentCount")) {
            verificationCondition.setDocumentCount(Integer.valueOf(Integer.parseInt(splitCondition[1])));
        } else if (splitCondition[0].equalsIgnoreCase("fileNameRegExp")) {
            verificationCondition.setFileNameRegExp(splitCondition[1]);
        } else if (splitCondition[0].equalsIgnoreCase("conditionType")) {
            verificationCondition.setConditionType(this.determineConditionType(splitCondition[1], errors));
        } else {
            errors.add("B\u0142\u0119dnie okre\u015blony atrybut warunkowy! Dozwolone atrybuty, to: documentClassName, documentClassId, documentCount, fileNameRegExp i conditionType");
            throw new IllegalArgumentException("B\u0142\u0119dnie okre\u015blony atrybut warunkowy! Dozwolone atrybuty, to: documentClassName, documentClassId, documentCount, fileNameRegExp i conditionType");
        }
    }

    private ConditionType determineConditionType(String conditionType, ValidationErrors errors) {
        if (conditionType.equals("=")) {
            return new EQCondition();
        }
        if (conditionType.equals("!=")) {
            return new NOTEQCondition();
        }
        if (conditionType.equals("<")) {
            return new LTCondition();
        }
        if (conditionType.equals("<=")) {
            return new LECondition();
        }
        if (conditionType.equals(">")) {
            return new GTCondition();
        }
        if (conditionType.equals(">=")) {
            return new GECondition();
        }
        errors.add("B\u0142\u0119dny operator por\u00f3wnania! Dozwolone operatory, to: =, !=, <, <=, >, >=.");
        throw new IllegalArgumentException("B\u0142\u0119dny operator por\u00f3wnania! Dozwolone operatory, to: =, !=, <, <=, >, >=.");
    }
}

