/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.common.documents.validators;

import com.suncode.cuf.common.Categories;
import com.suncode.cuf.common.utils.TranslatorService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityDocument;
import com.suncode.pwfl.workflow.activity.ActivityDocumentService;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@Validator
public class AttachedDocumentsValidator {
    private static final Logger log = LoggerFactory.getLogger(AttachedDocumentsValidator.class);
    private DocumentFinder documentFinder;
    private DocumentClassService docClassService;
    private ActivityDocumentService activityDocumentService;
    private PlatformTransactionManager txManager;
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private ActivityFinder activityFinder;

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("attached-doc-from-class-validator")).name("validator.doc.class.name")).description("validator.doc.class.desc")).category(new Category[]{Categories.DOCUMENTS})).documentationLink("confluence/x/LITK")).icon((Icon)SilkIconPack.BRIEFCASE)).parameter().id("docClasses").name("validator.doc.class.classes_param.name").description("validator.doc.class.classes_param.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("attachedHere").name("validator.doc.class.current_task_param.name").description("validator.doc.class.current_task_param.desc").type((Type)Types.BOOLEAN).create()).parameter().id("attachedToActivityType").name("validator.doc.class.attached_to_activity_type_param.name").description("validator.doc.class.attached_to_activity_type_param.desc").type((Type)Types.STRING).defaultValue((Object)"ALL").create()).parameter().id("activities").name("validator.doc.class.activities_param.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("alert").name("validator.alert_param.name_default").description("validator.alert_param.desc_default").type((Type)Types.STRING).create()).parameter().id("confirmation").name("validator.confirm_param.name_default").description("validator.confirm_param.desc_default").type((Type)Types.BOOLEAN).create();
    }

    public void validate(@Param String[] docClasses, @Param Boolean attachedHere, @Param String attachedToActivityType, @Param String[] activities, @Param String alert, @Param Boolean confirmation, ValidationContext validationContext, ValidationErrors errors, Translator translator) {
        this.setDocumentFinder();
        this.setDocClassService();
        this.setActivityDocumentService();
        String processId = validationContext.getProcessId();
        ActivityType activityType = ActivityType.valueOf(attachedToActivityType);
        List<String> activitiesIds = this.getActivitiesIds(activities, processId, attachedHere, validationContext, activityType);
        Assert.notEmpty(activitiesIds, (String)translator.getMessage("validator.doc.class.emptyActivities"));
        try {
            this.checkDocsInTransaction(docClasses, processId, errors, confirmation, alert, translator, attachedHere, activityType, activitiesIds);
        }
        catch (IllegalArgumentException e) {
            errors.add(e.getMessage());
        }
    }

    private List<String> getActivitiesIds(String[] activitiesDefIds, String processId, Boolean attachedHere, ValidationContext validationContext, ActivityType activityType) {
        if (Boolean.TRUE.equals(attachedHere)) {
            return Collections.singletonList(validationContext.getActivityId());
        }
        List allActivities = this.activityFinder.findByProcessId(processId, new String[]{"process"});
        switch (activityType) {
            case ALL: {
                return allActivities.stream().map(Activity::getActivityId).collect(Collectors.toList());
            }
            case CUSTOM: {
                return allActivities.stream().filter(activity -> ArrayUtils.contains((Object[])activitiesDefIds, (Object)activity.getActivityDefinitionId())).map(Activity::getActivityId).collect(Collectors.toList());
            }
        }
        return allActivities.stream().filter(activity -> activity.getActivityDefinitionId().equals(validationContext.getActivityDefId())).map(Activity::getActivityId).collect(Collectors.toList());
    }

    private void checkDocsInTransaction(final String[] docClasses, final String processId, final ValidationErrors errors, final Boolean confirmation, final String alert, final Translator translator, final Boolean attachedHere, final ActivityType attachedToActivityType, final List<String> activitiesIds) {
        if (this.txManager == null) {
            this.txManager = TransactionManagerFactory.getHibernateTransactionManager();
        }
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.txManager);
        transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                ArrayList docs = new ArrayList();
                AttachedDocumentsValidator.this.addDocuments(docClasses, processId, activitiesIds, docs);
                AttachedDocumentsValidator.this.checkFoundDocs(docs, errors, confirmation, alert, translator, attachedHere, activitiesIds, attachedToActivityType);
            }
        });
    }

    private void addDocuments(String[] docClasses, String processId, List<String> activitiesIds, List<WfDocument> docs) {
        ArrayList foundDocs = new ArrayList();
        log.info("Adding documents from activities: " + activitiesIds);
        activitiesIds.forEach(activityId -> foundDocs.addAll(this.documentFinder.getDocumentsFromActivity(processId, activityId, new String[]{"documentClass"})));
        log.info(foundDocs.size() + " documents have been found in activities.");
        if (ArrayUtils.isNotEmpty((Object[])docClasses)) {
            log.info("Filtering documents from classes: " + Arrays.toString(docClasses));
            ArrayList<Long> documentClassesIds = new ArrayList<Long>();
            for (String docClass : docClasses) {
                DocumentClass documentClass = this.docClassService.getDocumentClass(docClass, new String[0]);
                if (documentClass == null) {
                    throw new IllegalArgumentException(this.translatorService.translate("errors.", "docclassname_not_found") + docClass);
                }
                documentClassesIds.add(documentClass.getId());
            }
            for (WfDocument doc : foundDocs) {
                log.info("Document with id " + doc.getId());
                Long documentClassId = doc.getDocumentClassId();
                if (documentClassesIds.contains(documentClassId)) {
                    log.info("Has class with id: " + documentClassId);
                    docs.add(doc);
                    continue;
                }
                log.info("Does not have class with id: " + documentClassId);
            }
        } else {
            docs.addAll(foundDocs);
        }
    }

    private void checkFoundDocs(List<WfDocument> foundDocs, ValidationErrors errors, Boolean confirmation, String alert, Translator translator, Boolean attachedHere, List<String> activityIds, ActivityType attachedToActivityType) {
        if (foundDocs.isEmpty()) {
            this.addErrorOrConfirmation(confirmation, alert, errors, translator);
        } else if ((Boolean.TRUE.equals(attachedHere) || attachedToActivityType != ActivityType.ALL) && !this.checkIfAttachedHereDocumentExist(foundDocs, activityIds)) {
            this.addErrorOrConfirmation(confirmation, alert, errors, translator);
        }
    }

    private boolean checkIfAttachedHereDocumentExist(List<WfDocument> foundDocs, List<String> activityIds) {
        for (WfDocument doc : foundDocs) {
            log.info("Checking AddedHere for document fileId: " + doc.getFile().getId());
            for (String activityId : activityIds) {
                ActivityDocument activityDocument = this.activityDocumentService.getActivityDocument(doc.getFile().getId(), activityId);
                if (activityDocument == null || !activityDocument.isAddedHere()) continue;
                return true;
            }
        }
        log.info("AddedHere not found.");
        return false;
    }

    private void addErrorOrConfirmation(Boolean confirmation, String alert, ValidationErrors errors, Translator translator) {
        if (Boolean.TRUE.equals(confirmation)) {
            errors.addConfirmation(alert, translator.getMessage("validator.title_default"));
        } else {
            errors.add(alert);
        }
    }

    void setDocumentFinder(DocumentFinder df) {
        this.documentFinder = df;
    }

    private void setDocumentFinder() {
        if (this.documentFinder == null) {
            this.documentFinder = FinderFactory.getDocumentFinder();
        }
    }

    void setDocClassService(DocumentClassService dcs) {
        this.docClassService = dcs;
    }

    private void setDocClassService() {
        if (this.docClassService == null) {
            this.docClassService = ServiceFactory.getDocumentClassService();
        }
    }

    void setActivityDocumentService(ActivityDocumentService ads) {
        this.activityDocumentService = ads;
    }

    private void setActivityDocumentService() {
        if (this.activityDocumentService == null) {
            ActivityDocumentService ads;
            this.activityDocumentService = ads = (ActivityDocumentService)SpringContext.getInstance().getBean(ActivityDocumentService.class);
        }
    }

    void setTxManager(PlatformTransactionManager txManager) {
        this.txManager = txManager;
    }

    void setTranslatorService(TranslatorService translatorService) {
        this.translatorService = translatorService;
    }

    void setActivityFinder(ActivityFinder activityFinder) {
        this.activityFinder = activityFinder;
    }

    static enum ActivityType {
        ALL,
        CURRENT,
        CUSTOM;

    }
}

