(function (Ext, messages) {

	Ext.define('Suncode.pluginmanager.view.InstallForm', {
		extend: 'Ext.form.Panel',
		alias: 'widget.pluginmanager-installer',

		title: messages('view.installer.title'),
		layout: 'form',
		frame: true,
		url: Suncode.getAbsolutePath('/api/plugins/install'),
		updateUrl: Suncode.getAbsolutePath('/api/plugins/{0}/update'),

		initComponent: function () {
			Ext.apply(this, {
				items: [{
					xtype: 'filefield',
					name: 'file',
					msgTarget: 'under',
					allowBlank: false,
					regex: new RegExp('((.jar$)|(.lic$))', 'i'),
					buttonText: '',
					regexText: messages('error.nojar'),
					emptyText: messages('view.installer.empty'),
					clearOnSubmit: false
				}],
				buttons: [{
					text: messages('install'),
					iconCls: 'dvnt-icon-upload',
					handler: this.installPlugin,
					formBind: true,
					scope: this
				}]
			});

			this.callParent();
		},

		installPlugin: function () {
			var me = this,
				form = me.getForm();
			filename = form.getFields().get(0).getValue().replace(/^.*[\\\/]/, '');

			if (form.isValid()) {

				form.submit({
					waitMsg: messages('view.installer.wait', filename),
					success: function (form, action) {
						me.fireEvent('installed', action.result);

						if (action.result.alreadyInstalled) {
							Ext.Msg.show({
								title: PW.t('warningTitle'),
								msg: PW.t('Wtyczka_juz_zainstalowana_czy_chcesz_zaktualizowac'),
								buttons: Ext.Msg.YESNO,
								icon: Ext.window.MessageBox.QUESTION,
								fn: function (buttonId) {
									if (buttonId == "yes") {
										me.forceUpdatePlugin(action.result.entity.key);
									}
								},
							});
						}
					},
					failure: function (form, action) {
						PW.ui.Message.error(messages('plugins.view.failureInstallation' ));
					}
				});

			}
		},

		forceUpdatePlugin: function (pluginKey) {
			var form = this.getForm();
			var filename = form.getFields().get(0).getValue().replace(/^.*[\\\/]/, '');
			this.fireEvent('forceUpdate', null, form, filename, pluginKey);
		}
	});

}(Ext4, Suncode.pluginmanager.i18n.MessageSource.getMessage));