Ext.namespace('Ext.ux.plusmpm');

/**
 * Dodatkowe parametry konfiguracyjne:
 * 
 * config.processId : String
 * */
Ext.ux.plusmpm.ProcessAssignmentsWindow = function(config) {

	var proxy = new Ext.data.HttpProxy({
	    url : 'com.plusmpm.servlet.GetProcessAssignmentsServlet.customServlet'
	});
	
	var store = new Ext.data.JsonStore({
	    proxy         : proxy,
	    root          : 'records',
	    autoDestroy   : true,
	    baseParams    : {processId:config.processId},
	    fields        : [
	        {name:'id', type:'int'},	        
	        {name:'activityId', type:'string'},
	        {name:'activityName', type:'string'},	        
	        {name:'assignDate', type:'date', dateFormat:'time'},	        
	        {name:'assignees', type:'string'},
	        {name:'assigned', type:'boolean'}
	    ],
	    idProperty    : 'id',
        sortInfo      : {field:'assignDate', direction: 'DESC'}
	});
	
	store.load();
	
	var view = new Ext.grid.GridView({
		scrollOffset : 20
	});
	
	var grid = new Ext.grid.GridPanel({        
        store            : store,
        view             : view,
        loadMask         : true,
        columnLines      : true,
        autoScroll       : true,
        border           : false,
        autoExpandColumn : 'theAutoExpandColumnId',
        columns          : [
            {
        	    header    : this.activityNameColumnHeader,
        	    sortable  : true,
        	    dataIndex : 'activityName',
        	    width     : 250
            },
            {
            	xtype     : 'datecolumn',
            	header    : this.assignDateColumnHeader,
        	    sortable  : true,
        	    dataIndex : 'assignDate',
        	    width     : 150,
        	    format    : 'Y-m-d H:i:s'
            },
            {
            	xtype     : 'booleancolumn',
            	header    : this.assignedColumnHeader,
            	sortable  : true,
        	    dataIndex : 'assigned',
        	    width     : 110,
        	    falseText : '<img src=\"style/img/fam/group.png\"/>&nbsp;' + this.falseText,
        	    trueText  : '<img src=\"style/img/fam/user.png\"/>&nbsp;' + this.trueText
            },
            {
            	id        : 'theAutoExpandColumnId',
                header    : this.assigneesColumnHeader,
                sortable  : true,
                dataIndex : 'assignees',
                renderer  : function(oValue, oMetadata, rRecord, nRowIndex, nColIndex, oStore){
					oMetadata.attr = "style=\"white-space:normal;\"";
					return oValue;
				}
            }]
	});

    config = Ext.apply({
    	title           : this.windowTitle + ': [' + config.processId + ']',
        width           : 900,
        height          : 400,
        modal           : true,
        constrain       : true,
        layout          : 'fit',
        items           : grid,
        frame           : false
    }, config);
    
	Ext.ux.plusmpm.ProcessAssignmentsWindow.superclass.constructor.call(this, config);
}; // end of Ext.ux.plusmpm.ProcessAssignmentsWindow constructor

Ext.extend(Ext.ux.plusmpm.ProcessAssignmentsWindow, Ext.Window, {

	// to są nazwy domyślne, 
	// jeśli ustawiony język ma je zdefiniowane w odpowiednim pliku z tłumaczeniami
	// to tamta nazwa będzie ostatecznie użyta
	activityNameColumnHeader 	:  PW.t('activityNameColumnHeader'),
	assignDateColumnHeader 		:  PW.t('assignDateColumnHeader'),
	assignedColumnHeader 		:  PW.t('assignedColumnHeader'),
	assigneesColumnHeader 		:  PW.t('assigneesColumnHeader'),
	windowTitle 				:  PW.t('windowTitle'),
	falseText 					:  PW.t('falseText'),
	trueText 					:  PW.t('trueText'),

	initComponent : function() {
		Ext.ux.plusmpm.ProcessAssignmentsWindow.superclass.initComponent
				.call(this);
	}
}); // end of Ext.extend

function showProcessAssignmentsWindow(processId)
{
	var window = new Ext.ux.plusmpm.ProcessAssignmentsWindow({
		processId : processId
	});
	window.show();
}
