(function(Ext) {
	
	Ext.define('Suncode.datasourcemanager.view.DataSourceConfiguration', {
		extend: 'Ext.form.Panel',
		alias: 'widget.data-source-configuration',
		requires: ['Suncode.datasourcemanager.component.ParametersForm', 'Suncode.datasourcemanager.api.DynamicFormApi'],
        title: PW.t('data-source-configuration-new'),
        region: 'center',
        mixins: {
			tooltip: 'Suncode.datasourcemanager.mixins.ToolTip'
		},
		frame: true,
        layout : {
			type : 'vbox',
			align: 'stretch'
		},
		bodyPadding: 20,
		autoScroll: true,
		values: new Ext.util.MixedCollection(),
		defaults: {
		    labelWidth: 200,
		    labelPad: 10,
		    allowBlank: false
		},
		parametersContainer: undefined,
        items: [{
            xtype: 'combo',
            itemId: 'datasource-type-combo',
            fieldLabel: PW.t('data-source-type'),
            name: 'type',
            store: 'Suncode.datasourcemanager.store.DataSourceTypeStore',
            displayField: 'name',
            valueField: 'id',
			forceSelection: true,
            pageSize: 10,
            minChars: 0,
            queryCaching: false,
			displayTpl: Ext.create('Ext.XTemplate',
                '<tpl for=".">',
                    '{name} ({description})',
                '</tpl>'
            ),
            tpl: Ext.create('Ext.XTemplate',
        	    '<tpl for=".">',
        	        '<div role="option" unselectable="on" class="x4-boundlist-item">',
        	        	'<div><b>{name}</b></div>',
        	        	'<div><div class="tooltip-image" style="top: 0; margin-right: 3px;"></div>{description}</div>',
        	        '</div>',
        	    '</tpl>'
            )
        }, 
        {
        	xtype: 'combo',
        	itemId: 'datasource-operation-combo',
            fieldLabel: PW.t('data-source-operation'),
            name: 'operation',
            displayField: 'operation-name',
            valueField: 'operation',
			forceSelection: true,
            minChars: 0,
			queryMode: 'local',
            store: {
				fields : [
					{name: 'operation', type: 'string'},
					{name: 'operation-name', type: 'string', convert: function(value, record ){
						return PW.t('datasources-operation-' + record.data.operation.toLowerCase());
						}
					}
				],
            }
        },
		{
			xtype: 'combo',
			itemId: 'datasource-category-combo',
			fieldLabel: PW.t('category'),
			name: 'category',
			displayField: 'name',
			valueField: 'id',
			queryMode: 'local',
			allowBlank: true,
			store: 'Suncode.datasourcemanager.store.DataSourceCategoryStore'
		},
        {
            xtype: 'textfield',
            fieldLabel: PW.t('data-source-id'),
            name: 'id'
        }, {
            xtype: 'textfield',
            fieldLabel: PW.t('data-source-name'),
            name: 'name'
        }, {
            xtype: 'textfield',
            fieldLabel: PW.t('data-source-description'),
            name: 'description'
        }, {
			xtype: 'textfield',
			fieldLabel: PW.t('data-source-replace-semicolons'),
			name: 'replaceSemicolonsChar',
			allowBlank: true
		}, {
			xtype: 'checkbox',
			itemId: 'datasource-type-allow_cache',
			fieldLabel: PW.t('data_source_allow_cache'),
			name: 'allowCache'
		}, {
			xtype: 'numberfield',
			itemId: 'datasource-type-cache_expiration',
			fieldLabel: PW.t('data_source_cache_expiration_delay'),
			name: 'cacheExpirationDelaySec',
			allowBlank: true,
			validator() {
				value = this.getValue();
				if (value >= 0) {
					return true;
				}
				return PW.t('invalid_value');
			}
		}, {
        	xtype: 'parametersContainer',
        	itemId: 'parameters'
        }],

        parametersPanel: function(){
        	if( !this.parametersContainer ) {
        	    this.parametersContainer = this.down('#parameters');
        	}
            return this.parametersContainer;
        },
        
        getParameters: function() {
            return this.parametersPanel().parametersDefinition;
        },
        
        buildParameters: function() {
			var combo = this.down('#datasource-operation-combo');
            this.parametersPanel().buildParameters( this.componentDefinition, combo.getValue() );
        },
        
        removeAllParameters: function() {
            this.parametersPanel().removeAllParameters();
        },
        
        loadRecord: function(record) {
        	this.callParent(arguments);
        	this.parametersPanel().setValues(record.raw.parameters);
			this.originalCategory = record.data.category
			this.down("#datasource-category-combo").setValue(record.data.category)
        },
        
        setReadOnlyField: function(fieldName, condition) {
        	var field = this.getForm().findField(fieldName);
        	if(!field) {
        		return;
        	}
        	field.setReadOnly(condition);
        },
        
        setType: function( component ){
        	var combo = this.down('#datasource-type-combo'),
        	    store = combo.getStore();
        	var record = store.findRecord( 'id', component.id, 0, false, true, true );
        	if(record) {
        	    combo.setValue(record);
        	}
        	else {
        	    store.add(component);
                combo.setValue(component.id);
        	}
        },

		getAllowCache: function () {
			return this.getForm().findField("allowCache").value
		},

		setCacheExpiredVisible: function (allowCache) {
			this.getForm().findField("cacheExpirationDelaySec").setVisible(allowCache)
		},

		setOperationType: function( operations ) {
			var combo = this.down('#datasource-operation-combo');
			combo.getStore().loadData( jQuery.map( operations, function(operation){
				return {
					operation: operation
				}
			}) );
			if( operations.length == 1 ) {
				combo.setValue( operations[0] );
				combo.setReadOnly(true);
			}
			else {
				combo.clearValue();
				this.setReadOnlyField('operation', false);
			}
		},

		clearOperations: function() {
			var combo = this.down('#datasource-operation-combo');
			combo.clearValue();
			combo.getStore().removeAll();
		},

		shouldRefresh(){
			const category = this.down('#datasource-category-combo').getValue();
			return this.originalCategory !== category;
		}
	});
	
})(Ext4);