(function (Ext) {
    Ext.define('Suncode.audit.view.AuditFilters', {
        extend: 'Ext.panel.Panel',
        alias: 'widget.audit-filters',
        title: PW.t('filters'),
        collapsed: true,
        collapsible: true,
        titleCollapse: true,
        frame: true,
        border: false,
        width: 410,
        layout: 'form',
        filterTask: null,
        bodyPadding: 10,
        initComponent: function () {
            this.filterTask = Ext.util.TaskManager.newTask({
                run: this.filterAudits,
                scope: this,
                repeat: 1
            });

            this.items = [{
                xtype: 'box',
                filterFor: 'userId',
                autoEl: {
                    tag: 'div',
                    html: PW.t('user') + ':',
                    cls: 'x-audit-filter-name'
                }
            }, {
                xtype: 'combo',
                filterFor: 'userId',
                triggerAction: 'all',
                fieldLabel: '=',
                labelSeparator: '',
                anchor: '100%',
                labelCls: 'x-audit-label x-audit-filter-label',
                clearFilterOnBlur: false,
                minChars: 1,
                store: Ext.create('Suncode.audit.store.UserStore', {
                    storeId: 'userStore'
                }),
                valueField: 'userName',
                displayField: 'name',
                forceSelection: true,
                pageSize: 10
            }, {
                xtype: 'box',
                filterFor: 'ipAddress',
                hidden: true,
                autoEl: {
                    tag: 'div',
                    html: PW.t('ipAddress') + ':',
                    cls: 'x-audit-filter-name'
                }
            }, {
                xtype: 'textfield',
                filterFor: 'ipAddress',
                anchor: '100%',
                enableKeyEvents: true,
                labelCls: 'x-audit-label x-audit-filter-label',
                fieldLabel: '=',
                labelSeparator: '',
                hidden: true
            }, {
                xtype: 'box',
                filterFor: 'threadId',
                hidden: true,
                autoEl: {
                    tag: 'div',
                    html: PW.t('threadId') + ':',
                    cls: 'x-audit-filter-name'
                }
            }, {
                xtype: 'textfield',
                filterFor: 'threadId',
                anchor: '100%',
                enableKeyEvents: true,
                labelCls: 'x-audit-label x-audit-filter-label',
                fieldLabel: '=',
                labelSeparator: '',
                hidden: true
            }, {
                xtype: 'box',
                filterFor: 'auditType',
                autoEl: {
                    tag: 'div',
                    html: PW.t('name') + ':',
                    cls: 'x-audit-filter-name'
                }
            }, {
                xtype: 'combo',
                filterFor: 'auditType',
                triggerAction: 'all',
                fieldLabel: '=',
                labelSeparator: '',
                anchor: '100%',
                labelCls: 'x-audit-label x-audit-filter-label',
                queryMode: 'local',
                clearFilterOnBlur: false,
                store: Ext.create('Suncode.audit.store.AuditTypesStore', {
                    storeId: 'auditTypesStore'
                }),
                valueField: 'auditTypeId',
                displayField: 'auditTypeName',
                forceSelection: true,
                multiSelect: true,
                listeners: {
                    scope: this,
                    change: function (combo, newValue) {
                        if (Ext.isEmpty(newValue)) {
                            combo.setValue('');
                        }
                    },
                    beforequery: function (record) {
                        record.query = new RegExp(record.query, 'i');
                        record.forceAll = true;
                    }
                }
            }, {
                xtype: 'box',
                filterFor: 'auditStarted',
                autoEl: {
                    tag: 'div',
                    html: PW.t('startTime') + ':',
                    cls: 'x-audit-filter-name'
                }
            }, {
                xtype: 'fieldcontainer',
                filterFor: 'auditStarted',
                layout: 'hbox',
                labelCls: 'x-audit-label x-audit-filter-label',
                fieldLabel: '>',
                labelSeparator: '',
                anchor: '100%',
                items: [{
                    xtype: 'textfield',
                    filterFor: 'auditStartedFrom',
                    flex: 1,
                    readOnly: true,
                    listeners: {
                        afterrender: function (field) {
                            field.setValue(Ext.Date.format(new Date(new Date().getTime() - (24 * 3600 * 1000)), 'Y-m-d H:i'));
                        }
                    }
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon trigger-btn dvnt-icon-calendar',
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon trigger-btn dvnt-icon-delete',
                    scope: this,
                    handler: this.clearDateFilter
                }],
                listeners: {
                    scope: this,
                    afterrender: this.addCalendarAction
                }
            }, {
                xtype: 'fieldcontainer',
                filterFor: 'auditStarted',
                layout: 'hbox',
                labelCls: 'x-audit-label x-audit-filter-label',
                fieldLabel: '<',
                labelSeparator: '',
                anchor: '100%',
                items: [{
                    xtype: 'textfield',
                    filterFor: 'auditStartedTo',
                    flex: 1,
                    readOnly: true
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon trigger-btn dvnt-icon-calendar',
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon trigger-btn dvnt-icon-delete',
                    scope: this,
                    handler: this.clearDateFilter
                }],
                listeners: {
                    scope: this,
                    afterrender: this.addCalendarAction
                }
            }, {
                xtype: 'box',
                filterFor: 'auditStopped',
                autoEl: {
                    tag: 'div',
                    html: PW.t('stopTime') + ':',
                    cls: 'x-audit-filter-name'
                }
            }, {
                xtype: 'fieldcontainer',
                filterFor: 'auditStopped',
                layout: 'hbox',
                labelCls: 'x-audit-label x-audit-filter-label',
                fieldLabel: '>',
                labelSeparator: '',
                anchor: '100%',
                items: [{
                    xtype: 'textfield',
                    filterFor: 'auditStoppedFrom',
                    flex: 1,
                    readOnly: true
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon trigger-btn dvnt-icon-calendar',
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon trigger-btn dvnt-icon-delete',
                    scope: this,
                    handler: this.clearDateFilter
                }],
                listeners: {
                    scope: this,
                    afterrender: this.addCalendarAction
                }
            }, {
                xtype: 'fieldcontainer',
                filterFor: 'auditStopped',
                layout: 'hbox',
                labelCls: 'x-audit-label x-audit-filter-label',
                fieldLabel: '<',
                labelSeparator: '',
                anchor: '100%',
                items: [{
                    xtype: 'textfield',
                    filterFor: 'auditStoppedTo',
                    flex: 1,
                    readOnly: true
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon trigger-btn dvnt-icon-calendar',
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon trigger-btn dvnt-icon-delete',
                    scope: this,
                    handler: this.clearDateFilter
                }],
                listeners: {
                    scope: this,
                    afterrender: this.addCalendarAction
                }
            }, {
                xtype: 'box',
                filterFor: 'auditDuration',
                autoEl: {
                    tag: 'div',
                    html: PW.t('durationMs') + ':',
                    cls: 'x-audit-filter-name'
                }
            }, {
                xtype: 'fieldcontainer',
                filterFor: 'auditDuration',
                layout: 'hbox',
                labelCls: 'x-audit-label x-audit-filter-label',
                fieldLabel: '>',
                labelSeparator: '',
                anchor: '100%',
                items: [{
                    xtype: 'numberfield',
                    filterFor: 'auditDurationFrom',
                    allowDecimals: false,
                    minValue: 0,
                    flex: 1,
                    hideTrigger: true,
                    enableKeyEvents: true
                }]
            }, {
                xtype: 'fieldcontainer',
                filterFor: 'auditDuration',
                layout: 'hbox',
                labelCls: 'x-audit-label x-audit-filter-label',
                fieldLabel: '<',
                labelSeparator: '',
                anchor: '100%',
                items: [{
                    xtype: 'numberfield',
                    filterFor: 'auditDurationTo',
                    allowDecimals: false,
                    minValue: 0,
                    flex: 1,
                    hideTrigger: true,
                    enableKeyEvents: true
                }]
            }, {
                xtype: 'box',
                filterFor: 'auditSuccess',
                autoEl: {
                    tag: 'div',
                    html: PW.t('success') + ':',
                    cls: 'x-audit-filter-name'
                }
            }, {
                xtype: 'radiogroup',
                filterFor: 'auditSuccess',
                fieldLabel: '',
                columns: 1,
                vertical: true,
                items: [{
                    boxLabel: PW.t('all'),
                    name: 'auditSuccessOptions',
                    inputValue: 'AUDIT_ALL',
                    checked: true
                }, {
                    boxLabel: '<div class="audit-filter-icon dvnt-icon-check-symbol dvnt-green-icon"></div>',
                    name: 'auditSuccessOptions',
                    inputValue: 'true'
                }, {
                    boxLabel: '<div class="audit-filter-icon dvnt-icon-x-symbol dvnt-red-icon"></div>',
                    name: 'auditSuccessOptions',
                    inputValue: 'false'
                }]
            }, {
                xtype: 'box',
                filterFor: 'auditDetails',
                autoEl: {
                    tag: 'div',
                    html: PW.t('details') + ':',
                    cls: 'x-audit-filter-name'
                }
            }, {
                xtype: 'textfield',
                filterFor: 'auditDetails',
                anchor: '100%',
                enableKeyEvents: true,
                labelCls: 'x-audit-label x-audit-filter-label',
                fieldLabel: '=',
                labelSeparator: ''
            }, {
                xtype: 'container',
                margin: '10 0 10 0',
                items: [{
                    xtype: 'button',
                    style: 'width: 100%',
                    text: PW.t('search'),
                    scale: 'large',
                    scope: this,
                    handler: function () {
                        this.useFilterTask(1);
                    }
                }]
            }];

            this.callParent();
        },
        addCalendarAction: function (field) {
            var filter = field.down('textfield');
            var btn = field.down('button');

            Calendar.setup({
                inputField: filter.getId() + '-inputEl',
                ifFormat: '%Y-%m-%d %H:%M',
                button: btn.getId(),
                singleClick: true,
                showsTime: true,
                timeFormat: '24',
                onSelect: function onSelect(cal) {
                    filter.setValue(Ext.Date.format(cal.date, 'Y-m-d H:i'));

                    if (cal.params.singleClick && cal.dateClicked) {
                        cal.callCloseHandler();
                    }
                }
            });
        },
        clearDateFilter: function (button, e) {
            var filter = button.up('fieldcontainer').down('textfield');
            filter.setValue(null);
        },
        useFilterTask: function (interval) {
            this.filterTask.stop();
            this.filterTask.start(interval);
        },
        filterAudits: function () {
            var auditGrid = this.up('audit-panel').down('audit-grid');
            auditStore = auditGrid.getStore();
            auditStore.getProxy().extraParams = this.buildFilterConfig();
            auditStore.loadPage(1);
        },
        buildFilterConfig: function () {
            return {
                userId: this.getFilterValue('combo', 'userId'),
                ipAddress: this.getFilterValue('textfield', 'ipAddress'),
                threadId: this.getFilterValue('textfield', 'threadId'),
                auditType: this.getFilterValue('combo', 'auditType'),
                auditStartedFrom: this.getFilterValue('textfield', 'auditStartedFrom'),
                auditStartedTo: this.getFilterValue('textfield', 'auditStartedTo'),
                auditStoppedFrom: this.getFilterValue('textfield', 'auditStoppedFrom'),
                auditStoppedTo: this.getFilterValue('textfield', 'auditStoppedTo'),
                auditDurationFrom: this.getFilterValue('numberfield', 'auditDurationFrom'),
                auditDurationTo: this.getFilterValue('numberfield', 'auditDurationTo'),
                auditDetails: this.getFilterValue('textfield', 'auditDetails'),
                auditSuccess: this.getFilterValue('radiogroup', 'auditSuccess').auditSuccessOptions
            };
        },
        getFilterValue: function (xtype, filterFor) {
            var filter = this.query(xtype + '[filterFor=' + filterFor + ']')[0];
            var value = filter.getValue();

            if (Ext.isArray(value)) {
                return value.join(';');
            } else {
                return value;
            }
        }
    });
}(this.Ext4));