// Adds onmouseover, onmouseout, and onclick handlers to each table row.  The onmouseover handler changes the row's class attribute to
// rowMouseOver.  The onmouseout handler changes it back.  The onclick function makes a request for the specified url, including the
// innerHTML of the specified column as a request parameter.

function addRowHandlersForTable(tableId, content) {
	jQuery('#' + tableId + ' tr:not(:first)', content || document).each(function() {
		var row = jQuery(this);
		if( row.attr('class') && row.attr('class').indexOf('empty') > -1 ) {
			return;
		}
		addClassOnRowMouseOver(row);
		removeClassOnRowMouseOut(row);
		addOnCellClickHandler(row);
		addMaskOnDirectLinkClick(row);
	});
}

function addClassOnRowMouseOver(row) {
	row.mouseover(function(){
		row.addClass('rowMouseOver');
	});
}

function removeClassOnRowMouseOut(row) {
	row.mouseout(function(){
		row.removeClass('rowMouseOver');
	});
}

function addOnCellClickHandler(row) {
	row.find('td:not(:last-child)').each(function() {
		jQuery(this).click(function() {
			if( !isTextSelected() ) {
				showMask();
				var a = row.find('td:last a:first')[0];
				if(a) {
					a.click();
				}
			}
		});
	});
}

function isTextSelected() {
	var isSelected = false,
		text = "";
	if (window.getSelection) {
		text = window.getSelection().toString();
	}
	else {
		text = document.selection.createRange().text;
	}
	
	return text ? true : false;
}

function addMaskOnDirectLinkClick(row) {
	row.find('td:last a').each(function(){
		jQuery(this).click(function(){
			showMask();
		});
	});
}

function showMask() {
	if(typeof( Ext ) != "undefined")
	{
		maskBrowserWindow();
	}
}

function addRowHandlers(tableId, rowClassName, url, paramName, columnIndex)
{
	var previousClass = null;
	var table = document.getElementById(tableId);
	var rows = table.getElementsByTagName("tr");

	for (var i = 1; i < rows.length; i = i + 1)
	{
		if( rows[i].className && rows[i].className.indexOf('empty') > -1 ) {
			continue;
		}
		rows[i].onmouseover = function () {
			previousClass = this.className;
			this.className = this.className + " " + rowClassName;
		};

		rows[i].onmouseout = function () {
			this.className = previousClass;
		};

		var cells = rows[i].getElementsByTagName("td");
		for(var j = 0; j < cells.length; j = j + 1)
		{
			//sprawdzam czy w komorce sa jakies linki, jezeli tak to nie dodaje akcji dla komorki
			var cellLinks = cells[j].getElementsByTagName("a");
			if(cellLinks === null || cellLinks.length < 1)
			{
				cells[j].onclick = function () {
					//sprawdzamy czy użytkownik kliknął w celu skopiowania tekstu, jeżeli tak, to nie wywołujemy żadnej akcji
					var sel = isTextSelected();
					if(!sel) {
						//maskowanie po kliknieciu
						if(typeof( Ext ) != "undefined")
						{
							maskBrowserWindow();
						}
	
						var currentRow = this.parentNode;
						var cellWithParameters = currentRow.getElementsByTagName("td")[columnIndex];
						
						var paramValue = cellWithParameters.innerHTML;
						paramValue = paramValue.replace(new RegExp('amp;', 'g'), '&');
	
						if (paramName !== "")
						{
							location.href = url + "?" + paramName + "=" + paramValue;
						}
						else
						{
							location.href = url + "?" + paramValue;
						}
					}
					/*
					//usuniecie maski po wykonaniu akcji klikniecia
					if(typeof( Ext ) != "undefined")
					{
						unmaskBrowserWindow();
					}
					*/
				};
			}
			else
			{
				if(typeof( Ext ) != "undefined")
				{
					addMaskToManyElementsOnClick(cellLinks);
				}
			}
		}
	}
}

function addRowHandlersPreventDoubleClick(tableId, rowClassName, url, paramName, columnIndex)
{
	var previousClass = null;
	var table = document.getElementById(tableId);
	var rows = table.getElementsByTagName("tr");
    
	for (var i = 1; i < rows.length; i = i + 1)
	{
		if( rows[i].className && rows[i].className.indexOf('empty') > -1 ) {
			continue;
		}
		rows[i].onmouseover = function () {
			previousClass = this.className;
			this.className = this.className + " " + rowClassName;
		};
		
		rows[i].onmouseout = function () {
			this.className = previousClass;
		};
		
		var cells = rows[i].getElementsByTagName("td");
		for(var j = 0; j < cells.length; j = j + 1)
		{
			//sprawdzam czy w komorce sa jakies linki, jezeli tak to nie dodaje akcji dla komorki
			var cellLinks = cells[j].getElementsByTagName("a");
			if(cellLinks === null || cellLinks.length < 1)
			{
                var clicked = false;
				cells[j].onclick = function (e) {
					//sprawdzamy czy użytkownik kliknął w celu skopiowania tekstu, jeżeli tak, to nie wywołujemy żadnej akcji
					var sel = isTextSelected();
					if(!sel) {
						//maskowanie po kliknieciu
						if(typeof( Ext ) != "undefined")
						{
							maskBrowserWindow();
						}
	
						var currentRow = this.parentNode;          
						var cellWithParameters = currentRow.getElementsByTagName("td")[columnIndex];
						
						var paramValue = cellWithParameters.innerHTML;
						paramValue = paramValue.replace("amp;", "&");
						
                        if(!clicked)
                        {
                        	if (paramName !== "")
    						{
    							location.href = url + "?" + paramName + "=" + paramValue;
    						}
    						else
    						{
    							location.href = url + "?" + paramValue;
    						}
                        }
                        //zaznaczenie, że użytkownik kliknął link
						clicked = true;
					}
					/*
					//usuniecie maski po wykonaniu akcji klikniecia
					if(typeof( Ext ) != "undefined")
					{
						unmaskBrowserWindow();
					}
					*/
				};
			}
			else
			{
				if(typeof( Ext ) != "undefined")
				{					
					addMaskToManyElementsOnClick(cellLinks);
				}
			}
		}
	}
}

function addAdvanceRowHandlers(tableId, rowClassName, url, paramName, columnIndex)
{
	var previousClass = null;
	var table = document.getElementById(tableId);
	var rows = table.getElementsByTagName("tr");

	for (var i = 1; i < rows.length; i = i + 1)
	{
		if( rows[i].className && rows[i].className.indexOf('empty') > -1 ) {
			continue;
		}
		rows[i].onmouseover = function () {
			previousClass = this.className;
			this.className = this.className + " " + rowClassName;
		};

		rows[i].onmouseout = function () {
			this.className = previousClass;
		};

		var cells = rows[i].getElementsByTagName("td");
		for(var j = 0; j < cells.length; j = j + 1)
		{
			//sprawdzam czy w komorce sa jakies linki, jezeli tak to nie dodaje akcji dla komorki
			var cellLinks = cells[j].getElementsByTagName("a");
			if(cellLinks === null || cellLinks.length < 1)
			{
				cells[j].onclick = function () {
					//sprawdzamy czy użytkownik kliknął w celu skopiowania tekstu, jeżeli tak, to nie wywołujemy żadnej akcji
					var sel = isTextSelected();
					if(!sel) {
						//maskowanie po kliknieciu
						if(typeof( Ext ) != "undefined")
						{
							maskBrowserWindow();
						}
	
						var currentRow = this.parentNode;
						var currentCells = currentRow.getElementsByTagName("td");
						columnIndex = currentCells.length - 1;
	
						var cellWithParameters = currentCells[columnIndex];
						var paramValue = cellWithParameters.innerHTML;
						paramValue = paramValue.replace(/&amp;/g, "&");
	
						if (paramName !== "")
						{
							location.href = url + "?" + paramName + "=" + paramValue;
						}
						else
						{
							location.href = paramValue;
						}
					}
					/*
					//usuniecie maski po wykonaniu akcji klikniecia
					if(typeof( Ext ) != "undefined")
					{
						unmaskBrowserWindow();
					}
					*/
				};
			}
			else
			{
				if(typeof( Ext ) != "undefined")
				{
					addMaskToManyElementsOnClick(cellLinks);
				}
			}
		}
	}
}

function addTaskRowHandlers(tableId, rowClassName, url, paramName, columnIndex)
{
	var previousClass = null;
	var table = document.getElementById(tableId);
	var rows = table.getElementsByTagName("tr");

	for (var i = 1; i < rows.length; i = i + 1)
	{
		if( rows[i].className && rows[i].className.indexOf('empty') > -1 ) {
			continue;
		}
		rows[i].onmouseover = function () {
			previousClass = this.className;
			this.className = this.className + " " + rowClassName;
		};

		rows[i].onmouseout = function () {
			this.className = previousClass;
		};

		var cells = rows[i].getElementsByTagName("td");
		for(var j = 0; j < cells.length; j = j + 1)
		{
			//sprawdzam czy w komorce sa jakies linki, jezeli tak to nie dodaje akcji dla komorki
			var cellLinks = cells[j].getElementsByTagName("a");
			if(cellLinks === null || cellLinks.length < 1)
			{
				cells[j].onclick = function () {
					//sprawdzamy czy użytkownik kliknął w celu skopiowania tekstu, jeżeli tak, to nie wywołujemy żadnej akcji
					var sel = isTextSelected();
					if(!sel) {
						//maskowanie po kliknieciu
						if(typeof( Ext ) != "undefined")
						{
							maskBrowserWindow();
						}
	
						var currentRow = this.parentNode;
						var cellWithParameters = currentRow.getElementsByTagName("td")[columnIndex];
						var paramValue = cellWithParameters.innerHTML;
						paramValue = paramValue.replace("amp;", "&");
	
						if (paramName !== "")
						{
							location.href = url + "?" + paramName + "=" + paramValue;
						}
						else
						{
							if (url !== "")
							{
								location.href = url + "?" + paramValue;
							}
							else
							{
								location.href = paramValue;
							}
						}
					}
					/*
					//usuniecie maski po wykonaniu akcji klikniecia
					if(typeof( Ext ) != "undefined")
					{
						unmaskBrowserWindow();
					}
					*/
				};
			}
			else
			{
				if(typeof( Ext ) != "undefined")
				{
					addMaskToManyElementsOnClick(cellLinks);
				}
			}
		}
	}
}


function addComboRowHandlers(tableId, rowClassName, url, paramName, columnIndex)
{
	var previousClass = null;
	var table = document.getElementById(tableId);
	var rows = table.getElementsByTagName("tr");

	for (var i = 0; i < rows.length; i = i + 1)
	{
		if( rows[i].className && rows[i].className.indexOf('empty') > -1 ) {
			continue;
		}
		rows[i].onmouseover = function () {
			previousClass = this.className;
			this.className = this.className + " " + rowClassName;
		};

		rows[i].onmouseout = function () {
			this.className = previousClass;
		};

		rows[i].onclick = function () {
			//sprawdzamy czy użytkownik kliknął w celu skopiowania tekstu, jeżeli tak, to nie wywołujemy żadnej akcji
			var sel = isTextSelected();
			if(!sel) {
				var cellWithParameters = this.getElementsByTagName("td")[columnIndex];
				var paramValue = cellWithParameters.innerHTML;
				paramValue = paramValue.replace("amp;", "&");
	
				if (url !== "")
				{
					var paramObj = document.getElementById(paramName);
					paramObj.value = paramValue;
	
					cellWithParameters = this.getElementsByTagName("td")[columnIndex + 1];
					paramValue = cellWithParameters.innerHTML;
					paramValue = paramValue.replace("amp;", "&");
	
					paramObj = document.getElementById(paramName + "Name");
					paramObj.value = paramValue;
	
					tt_HideInit();
					PW.ui.ModalWindow.hide();
				}
			}
		};
	}
}

function addMyRowHandlers(tableId, rowClassName, url, paramName, columnIndex)
{
	var previousClass = null;
	var table = document.getElementById(tableId);
	var rows = table.getElementsByTagName("tr");

	for (var i = 1; i < rows.length; i = i + 1)
	{
		if( rows[i].className && rows[i].className.indexOf('empty') > -1 ) {
			continue;
		}
		rows[i].onmouseover = function () {
			previousClass = this.className;
			this.className = this.className + " " + rowClassName;
		};

		rows[i].onmouseout = function () {
			this.className = previousClass;
		};

		var cells = rows[i].getElementsByTagName("td");
		for(var j = 0; j < cells.length; j = j + 1)
		{
			//sprawdzam czy w komorce sa jakies linki, jezeli tak to nie dodaje akcji dla komorki
			var cellLinks = cells[j].getElementsByTagName("a");
			if(cellLinks === null || cellLinks.length < 1)
			{
				cells[j].onclick = function () {
					//sprawdzamy czy użytkownik kliknął w celu skopiowania tekstu, jeżeli tak, to nie wywołujemy żadnej akcji
					var sel = isTextSelected();
					if(!sel) {
						var currentRow = this.parentNode;
						var cellWithParameters = currentRow.getElementsByTagName("td")[columnIndex];
						var paramValue = cellWithParameters.innerHTML;
	
						var text = url + "?" + paramValue;
						var text2 = "menubar=no,toolbar=no,location=no,directories=no,status=no,scrollbars=yes,resizable=yes,fullscreen=no,channelmode=no,width=" + screen.width / 2 + ",height=" + screen.height + ",left=" + screen.width / 2 + ",top=0";
	
						var oWindow = window.open(text, "viewer", text2);
						oWindow.focus();
					}
				};
			}
			else
			{
				if(typeof( Ext ) != "undefined")
				{
					addMaskToManyElementsOnClick(cellLinks);
				}
			}
		}
	}
}

function addAdvanceRowHandlersForUserViewResult(tableId, rowClassName, url, paramName, columnIndex)
{
	var previousClass = null;
	var table = document.getElementById(tableId);
	var rows = table.getElementsByTagName("tr");

	for (var i = 1; i < rows.length; i = i + 1)
	{
		if( rows[i].className && rows[i].className.indexOf('empty') > -1 ) {
			continue;
		}
		rows[i].onmouseover = function () {
			previousClass = this.className;
			this.className = this.className + " " + rowClassName;
		};

		rows[i].onmouseout = function () {
			this.className = previousClass;
		};

		var cells = rows[i].getElementsByTagName("td");
		for(var j = 0; j < cells.length; j = j + 1)
		{
			//sprawdzam czy w komorce sa jakies linki lub elementy formularza (jak checkbox), jezeli tak to nie dodaje akcji dla komorki
			var cellLinks = cells[j].getElementsByTagName("a");
			var cellInputs = cells[j].getElementsByTagName("input");

			var bContainsNoLinks = (cellLinks === null || cellLinks.length < 1);
			var bContainsNoInputs = (cellInputs === null || cellInputs.length < 1);

			if(bContainsNoLinks === true && bContainsNoInputs === true)
			{
				cells[j].onclick = function () {
					//sprawdzamy czy użytkownik kliknął w celu skopiowania tekstu, jeżeli tak, to nie wywołujemy żadnej akcji
					var sel = isTextSelected();
					if(!sel) {
						//maskowanie po kliknieciu
						if(typeof( Ext ) != "undefined")
						{
							maskBrowserWindow();
						}
	
						var currentRow = this.parentNode;
						var currentCells = currentRow.getElementsByTagName("td");
						columnIndex = currentCells.length - 1;
	
						var cellWithParameters = currentRow.getElementsByTagName("td")[columnIndex];
						var paramValue = cellWithParameters.innerHTML;
						paramValue = paramValue.replace(/&amp;/g, "&");
						
						if (paramName !== "")
						{
							location.href = url + "?" + paramName + "=" + paramValue;
						}
						else
						{
							location.href = paramValue;
						}
					}
					/*
					//usuniecie maski po wykonaniu akcji klikniecia
					if(typeof( Ext ) != "undefined")
					{
						unmaskBrowserWindow();
					}
					*/
				};
			}
			else if(bContainsNoLinks === false)
			{
				if(typeof( Ext ) != "undefined")
				{
					addMaskToManyElementsOnClick(cellLinks);
				}
			}
		}
	}
}
