<%@page language="Java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="/tags/struts-bean" prefix="bean"%>
<%@ taglib uri="/tags/struts-html" prefix="html"%>
<%@ taglib uri="/tags/struts-logic" prefix="logic"%>
<%@ taglib uri="/tags/c" prefix="c"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display" %>

<%@page import="org.springframework.context.i18n.LocaleContextHolder"%>

<link rel="stylesheet" type="text/css" media="all" href="style/calendar-system.css" title="win2k-cold-1" />
<script type="text/javascript" src="scripts/calendar.js"></script>
<script type="text/javascript" src="scripts/lang/calendar-<%=LocaleContextHolder.getLocale().getLanguage()%>.js"></script>
<script type="text/javascript" src="scripts/calendar-setup.js"></script>

<script>

	function checkAll(parentId, checked)
	{
		var checkboxes = Ext.select('input[type=checkbox]', true, parentId);
		checkboxes.each(function(el) {
			if(el.hasClass('uncheckable') == false ) {
				el.dom.checked = checked;
				handleCheckBoxChange(el.id, el.dom.checked);
			}
		});
	}

	function handleCheckBoxChange(id, checked) {
		if (supportsLocalStorage &&  id !== 'check-all' ){
			window.localStorage.setItem("checkbox_" + id, checked);
		}
	}

	function supportsLocalStorage() {
		try {
			return 'localStorage' in window && window['localStorage'] !== null;
		} catch (e) {
			return false;
		}
	}

</script>

<c:choose>
	<c:when test="${param.source == 'docclass'}">
		<jsp:include page="/pages/archive/docClassFilters.jsp" flush="true"></jsp:include>
	</c:when>
	<c:otherwise>
		<jsp:include page="/pages/archive/linkFilters.jsp" flush="true"></jsp:include>
	</c:otherwise>
</c:choose>

<div id="showColumnTip" class="x-hidden">
	<bean:message key="Wyswietl_kolumne_w_wynikach_wyszukiwania"/>
</div>

<div id="checkAllTip" class="x-hidden">
	<bean:message key="Zaznacz_odznacz_wszystkie"/>
</div>

<script>
	Ext.onReady(function(){
		initToolTips();
		
		var showColumnTip = new Ext.Tip({
			maxWidth: 140,
	        contentEl: 'showColumnTip',
	        floating: true,
	        shadow: false
	    });

		var checkboxes = Ext.select('input[type=checkbox]');
		checkboxes.each(function(el) {
			if(el.hasClass('no-tip') == false &&  el.hasClass('check-all') == false) {
				el.on('mouseenter', function(e, el){
					showColumnTip.showBy(el, 'br');
				});
				el.on('mouseleave', function(e, el){
					showColumnTip.hide();
				});
				el.on('click', function (e, el) {
					handleCheckBoxChange(el.id, el.checked);
				});
				el.on('unchecked', function (e, el) {
					handleCheckBoxChange(el.id, el.checked);
				});
			}
			if(el.hasClass('additional_filter') || el.hasClass('docclass_checkbox'))
			{
				el.on('click', function(e,el){
					handleCheckBoxChange(el.id, el.checked);
				});
			}
		});
		
		var checkAllTip = new Ext.Tip({
	        contentEl: 'checkAllTip',
	        floating: true,
	        shadow: false
	    });

		checkboxes = Ext.select('input[type=checkbox]');
		checkboxes.each(function(el) {
			if(el.hasClass('check-all')) {
				el.on('mouseenter', function(e, el){
					checkAllTip.showBy(el, 'br');
				});
				el.on('mouseleave', function(e, el){
					checkAllTip.hide();
				});
			}
		});

		checkboxes = Ext.select('input[type=checkbox]', true, "idxTable");
		var additionalFilters = Ext.select('input[type=checkbox]', true, "tbody_versioning");
		var localStorageCheckboxes = [];
		if(supportsLocalStorage){
			checkboxes.each(function(el) {
				selectCheckboxFromLocalStorage(el, localStorageCheckboxes);
			});
			additionalFilters.each(function(el) {
				selectCheckboxFromLocalStorage(el, localStorageCheckboxes);
			});
		}
		
		if (localStorageCheckboxes.length < 1) {
			var checkedCheckboxesCount = 0;
			checkboxes.each(function (el) {
				var checkbox = el.dom;
				if (checkedCheckboxesCount < 6 && !checkbox.classList.contains('check-all')) {
					checkbox.checked = true;
					handleCheckBoxChange(checkbox.id, checkbox.checked);
					checkedCheckboxesCount++;
				}
			});
		}
	}, {single: true});

	function selectCheckboxFromLocalStorage(el, localStorageCheckboxes)
	{
		var checkbox = el.dom;
		if (checkbox.type === 'checkbox' && !checkbox.classList.contains('check-all')){
			if ( window.localStorage.hasOwnProperty("checkbox_" + checkbox.id)) {
				var localeStorageCheckbox = window.localStorage.getItem("checkbox_" + checkbox.id);
				localStorageCheckboxes.push(checkbox);
				checkbox.checked = JSON.parse(localeStorageCheckbox);
			}
		}
		if(checkbox.id === 'showVersion' && !window.localStorage.hasOwnProperty("checkbox_showVersion"))
		{
			checkbox.checked = true;
		}
	}
	
	function switchDisplayMode( switcherButton ) {
		var $switcherButton = jQuery(switcherButton),
				$rowWrapper = $switcherButton.closest('tr.wrapper-row'),
				searchMode = $rowWrapper.attr('searchmode'),
				$secondRowWrapper;
		var $td = $rowWrapper.parent();
		var $searchModeInput = $td.find('input.search_mode');
		var $activeFirstInput = $rowWrapper.find("input.first_input");
		var name = $activeFirstInput.attr("name");
		$activeFirstInput.removeAttr('name');

		if (searchMode === 'range') {
			$secondRowWrapper = $td.find('tr[searchmode=single]');
			$searchModeInput.val("single");
			var $secondRowInput = $secondRowWrapper.find("input.first_input");
			$secondRowInput.attr("name", name );
			$secondRowInput.val($activeFirstInput.val());
			$rowWrapper.find("input.second_input").val("");

		} else {
			$secondRowWrapper = $td.find('tr[searchmode=range]');
			$searchModeInput.val("range");
			var $firstRowInput = $secondRowWrapper.find("input.first_input");
			$firstRowInput.attr("name", name );
			$firstRowInput.val($activeFirstInput.val());
			$rowWrapper.find("input.second_input").val("");
		}

		$rowWrapper.toggle();
		$secondRowWrapper.toggle();
	}

	function initToolTips() {
		Ext.QuickTips.init();
		Ext.apply(Ext.QuickTips.getQuickTip(), {
			showDelay: 500
		});
	}

	var textSearchToolTip = new Ext.Tip({
		html: PW.t('text_search_tooltip')
	});

	var numericSearchToolTip = new Ext.Tip({
		html: PW.t('index_numeric_search_tooltip')
	});

	var dateSearchToolTip = new Ext.Tip({
		html: PW.t('index_date_search_tooltip')
	});

	function showStringTooltip(item){
		var el = Ext.select('#'+item.id);
		textSearchToolTip.showBy(el.elements[0]);
	}

	function showNumericTooltip(item){
		var el = Ext.select('#'+item.id);
		numericSearchToolTip.showBy(el.elements[0]);
	}

	function showDateTooltip(item){
		var el = Ext.select('#'+item.id);
		dateSearchToolTip.showBy(el.elements[0]);
	}

	function hideStringTooltip(){
		textSearchToolTip.hide();
	}

	function hideNumericTooltip(){
		numericSearchToolTip.hide();
	}

	function hideDateTooltip(){
		dateSearchToolTip.hide();
	}

</script>