(function(Ext) {

	Ext.define('Suncode.datasourcemanager.view.Viewport', {
		extend : 'Ext.panel.Panel',
		alias : 'widget.datasourcemanager-viewport',
		layout : 'border',
		style : {
			margin : '10px 0 0 0',
			background : 'none'
		},
		bodyStyle: {
			border: 'none'
		},
		height : 1000,
		minWidth : 400,

		items: [{
			xtype: 'data-source-tree',
			split: true,
			tbar: [
				{
					xtype: "form",
					flex: 1,
					layout: 'anchor',
					defaults: {
						anchor: '100%'
					},
					itemId: "filterForm",
					border: 0,
					items: [{
						xtype: 'textfield',
						itemId: 'treeFilter',
						emptyText: PW.t('filter') + '...',
						name: "query"
					}, {
						xtype: 'combo',
						itemId: 'datasource-category-combo-filter',
						emptyText: PW.t('category'),
						name: 'category',
						displayField: 'name',
						valueField: 'id',
						queryMode: 'local',
						allowBlank: true,
						store: 'Suncode.datasourcemanager.store.DataSourceCategoryStore'
					}]
				}],
			bbar: [{
				xtype: 'button',
				id: 'new-data-source-button',
				text: PW.t('new-data-source'),
				iconCls: 'dvnt-icon-plus-symbol'
			},{
                xtype: 'button',
                id: 'export-data-sources-button',
                text: PW.t('eksportuj'),
                menu: {
                    xtype: 'menu',
                    shadow: false,
                    border: false,
                    items: [{
                        text: PW.t('all'),
                        id: 'export-all-data-sources-button'
                    },{
                        text: PW.t('selected'),
                        id: 'export-selected-data-sources-button'
                    }]
                },
                iconCls: 'dvnt-icon-up-straight'
            },{
                xtype: 'button',
                id: 'import-data-sources-button',
                text: PW.t('importuj'),
                iconCls: 'dvnt-icon-down-straight'
            }]
		}, {
            xtype: 'data-source-configuration',
            id: 'data-source-configuration',
            bbar: [
            	{
					xtype: 'button',
					id: 'create-data-source-button',
					text: PW.t('create-data-source'),
					iconCls: 'dvnt-icon-folder-plus'
				}, {
					xtype: 'button',
					id: 'save-data-source-button',
					text: PW.t('save-data-source'),
					iconCls: 'dvnt-icon-save'
				}, {
					xtype: 'button',
					id: 'remove-data-source-button',
					text: PW.t('remove-data-source'),
					iconCls: 'dvnt-icon-x-symbol'
				}, {
                    xtype: 'button',
                    id: 'copy-data-source-button',
                    text: PW.t('copy-data-source'),
					iconCls: 'dvnt-icon-pen'
                }, {
                    xtype: 'button',
                    id: 'execute-data-source-button',
                    text: PW.t('datasources-execute'),
                    iconCls: 'dvnt-icon-right'
                }
			]
        }]
	});

}(Ext4));
