(function(Ext) {
	
	Ext.define('Suncode.datasourcemanager.model.DataSource', {
		extend: Ext.data.Model,
		fields: [
			{name: 'id', type: 'string'},
			{name: 'name', type: 'string'},
			{name: 'description', type: 'string'},
			{name: 'type', type: 'string'},
			{name: 'operation', type: 'string'},
			{name: 'replaceSemicolonsChar', type: 'string'},
			{name: 'allowCache', type: 'boolean'},
			{name: 'cacheExpirationDelaySec', type: 'string'},
			{
				name: 'category',
				convert: function (category, rec) {
					return category == null ? null : category.id
				}
			}
		],
		
		proxy: {
			type: 'rest',
			url: Suncode.getAbsolutePath('/api/datasources'),
			api: {
			    create  : Suncode.getAbsolutePath('/api/datasources/new'),
			    read    : Suncode.getAbsolutePath('/api/datasources/declaration'),
			    update  : Suncode.getAbsolutePath('/api/datasources/save'),
			    destroy : Suncode.getAbsolutePath('/api/datasources/declaration')
			}
		}
	});
	
}(Ext4));