(function (window) {
  var $ = jQuery;
  Suncode.ui = Suncode.ui || {};

  // EasyTabs
  $.extend(Suncode.ui, {
    tabs: function (target, options) {
      var tabs = $(target),
        settings;

      settings = $.extend(
        {},
        {
          animate: false,
          cache: false,
          tabs: 'ul > li',
        },
        options
      );

      var tabsEventsAlreadyRegistered = window.tabsEventsAlreadyRegistered;
      if (tabsEventsAlreadyRegistered) {
        Suncode.ui.showLoading();
      } else {
        $(tabs).on('easytabs:ajax:beforeSend', Suncode.ui.showLoading);
      }

      // stwórz easytabs
      $(tabs).easytabs(settings);

      if (!settings.cache) {
        $(tabs).on('easytabs:before', function (e, tab, panel, settings) {
          // wyczyść wszystkie zakładki
          $(panel).parent().children().empty();
        });
      }

      window.tabsEventsAlreadyRegistered = true;

      return $(tabs);
    },
  });

  // Maska ładowania
  var cssOn = 'FreezePaneOn',
    cssOff = 'FreezePaneOff',
    indicator = '#FreezePane';

  $.extend(Suncode.ui, {
    showLoading: function () {
      $(indicator).removeClass(cssOff).addClass(cssOn);
    },

    hideLoading: function () {
      $(indicator).removeClass(cssOn).addClass(cssOff);
    },
  });

  PW.ui = $.extend(
    {},
    {
      Message: {},
      ModalWindow: {},
      Portlet: {},
      FloatedButton: {},
      CaptchaConfirmation: {},
      version: 1,
    },
    Suncode.ui
  );

  $.extend(PW.ui.Message, {
    id: '#message-cloud',
    element:
      '<div id="message-cloud" class="message-box cloud {type}" style="display: flex;">' +
      '<div class="message-box-icon-wrapper">' +
      '<div class="message-box-icon"></div>' +
      '</div>' +
      '<p>{message}</p>' +
      '<div class="copy-button" style="display:{copyButtonStyle}" onclick={PW.ui.Message.copyCloudPopupMessage(this)}></div>' +
      '<div class="close-button" style="display:{closeButtonStyle}" onclick={PW.ui.Message.closeCloudPopup(this)}></div>' +
      '</div>',
    defaults: {
      hideAfter: 5000,
      type: 'info',
      showCopyButton: false,
    },

    success: function (message, config) {
      this.show(message, 'success', config);
    },

    error: function (message, config) {
      this.show(message, 'error', config);
    },

    warning: function (message, config) {
      this.show(message, 'warning', config);
    },

    info: function (message, config) {
      this.show(message, 'info', config);
    },

    show: function (message, type, config) {
      if (message) {
        type = type || this.defaults.type;
        var settings = $.extend({}, this.defaults, config);

        var $cloud = $(
          this.element
            .replace('{type}', type)
            .replace('{message}', message)
            .replace('{closeButtonStyle}', settings.hideAfter > 0 ? 'none' : 'block')
            .replace('{copyButtonStyle}', settings.showCopyButton ? 'block' : 'none')
        ).addClass(settings.hideAfter === 0 ? 'no-rearrange' : '');

        var $container = $('body').find('[data-message-container="true"]');
        if ($container.length === 0) {
          $container = $('<div>').attr('data-message-container', 'true');
          $('body').append($container);
        }

        $container.append($cloud);

        const messages = $container.children();
        if (messages.length > 1) {
          const previousPopup = messages.eq(messages.length - 2);
          const previousPopupBottom = previousPopup.offset().top + previousPopup.outerHeight() + 2;
          const scrollTop = $(window).scrollTop();
          $cloud.css('top', previousPopupBottom - scrollTop);
        }

        $cloud.fadeIn();

        if (settings.hideAfter > 0) {
          let me = this;
          $cloud.delay(settings.hideAfter).queue(function (next) {
            me.rearrangeMessages($container, this);
            $(this).remove();

            next();
          });
        }
      }
    },

    rearrangeMessages: function ($container, message) {
      let $popup = $(message);
      this.rearrangeMessagesWithParameters($container, $popup.position().top, $popup.outerHeight());
    },

    rearrangeMessagesWithParameters: function ($container, top, height) {
      $container.children().each(function (index) {
        const $message = $(this);
        const messageTop = $message.position().top;

        if (messageTop < top) {
          return;
        }

        const newMessageOffsetTop = messageTop - height - 2;
        $message.css('top', newMessageOffsetTop);
      });
    },

    closeCloudPopup: function (button) {
      var popup = jQuery(button).parent();
      this.rearrangeMessagesWithParameters(popup.parent(), popup.position().top, popup.outerHeight());
      popup.remove();
    },

    copyCloudPopupMessage: function (button) {
      navigator.clipboard.writeText(button.parentElement.innerText);
    },
  });

  $.extend(PW.ui.ModalWindow, {
    id: 'modal-window',
    windows: [],
    show: function (title, contentUrl, config) {
      config = Ext.apply({}, config);
      config = Ext.apply(
        {
          id: PW.ui.ModalWindow.id + (PW.ui.ModalWindow.windows.length + 1),
          url: contentUrl,
          title: title,
        },
        config
      );

      var window = new Ext.ux.suncode.ModalWindow(config);
      PW.ui.ModalWindow.windows.push(window);
      window.render();
    },

    hide: function () {
      if (PW.ui.ModalWindow.windows.length > 0) {
        PW.ui.ModalWindow.windows[PW.ui.ModalWindow.windows.length - 1].destroy();
      }
    },

    remove: function () {
      PW.ui.ModalWindow.windows.pop();
      if (PW.ui.ModalWindow.windows.length == 0) {
        Ext.getBody().setStyle('overflow', 'auto');
      }
    },
  });

  $.extend(PW.ui.Portlet, {
    resetForm: function (portletId) {
      const uncheckedEvent = new Event('unchecked');
      var form = jQuery('#' + portletId);
      form
        .find(':input:not(.not-resettable)')
        .not(':button, :submit, :reset, :hidden')
        .removeAttr('checked')
        .removeAttr('selected')
        .not('‌​:checkbox, :radio, select')
        .val('');
      form
        .find(':input:not(.not-resettable)')
        .not(':button, :submit, :reset, :hidden')
        .not('‌​:checkbox, :radio, select')
        .each(function (index, el) {
          el.dispatchEvent(uncheckedEvent);
        });
      form.find('select:not(.not-resettable)').each(function (index, select) {
        select.selectedIndex = 0;
      });
      form.find('.selectized').each(function (index, select) {
        select.selectize.clear();
      });
    },

    toggle: function (portletId) {
      var expandIconCls = 'dvnt-icon-down-straight',
        collapseIconCls = 'dvnt-icon-up-straight',
        collapsedCls = 'collapsed',
        portlet = jQuery('#' + portletId),
        content = jQuery('#' + portletId + 'Content'),
        sizeEl = jQuery('#' + portletId + 'Size');

      content.toggle();

      if (content.is(':visible')) {
        portlet.removeClass(collapsedCls);
        sizeEl.removeClass(expandIconCls);
        sizeEl.addClass(collapseIconCls);
      } else {
        portlet.addClass(collapsedCls);
        sizeEl.removeClass(collapseIconCls);
        sizeEl.addClass(expandIconCls);
      }
    },

    applyFeatures: function (portletId) {
      var form = jQuery('#' + portletId);

      PW.ui.Portlet.applyEnterSubmittion(form);
      PW.ui.Portlet.ensureTabInsideForm(form);
    },

    applyEnterSubmittion: function (form) {
      form.find('input').on('keypress', function (e) {
        if (e.which == 10 || e.which == 13) {
          form.find('.buttons a').first().click();
        }
      });
    },

    ensureTabInsideForm: function (form) {
      var firstItem = form.find('input, select').first(),
        lastItem = form.find('.buttons a').last();

      firstItem.on('keydown', function (e) {
        if (e.which == 9 && event.shiftKey) {
          e.preventDefault();
          lastItem.focus();
        }
      });
      lastItem.on('keydown', function (e) {
        if (e.which == 9 && !event.shiftKey) {
          e.preventDefault();
          firstItem.focus();
        }
      });
    },

    ajaxToggleSupport: function (collapsedOnInit) {
      jQuery(document).ready(function () {
        var portlet = jQuery('.portlet-panel-box'),
          portletContent = jQuery('.portlet-panel-content'),
          collapsedCls = 'collapsed';

        if (!portlet.length) return;

        if (collapsedOnInit) portlet.addClass(collapsedCls);

        jQuery('.portlet-panel-size, .portlet-panel-title').on('click', function () {
          portletContent.is(':visible') ? portlet.addClass(collapsedCls) : portlet.removeClass(collapsedCls);
        });
      });
    },
  });
})(window);
